/*
 * Created by IntelliJ IDEA.
 * User: karu
 * Date: Mar 25, 2003
 * Time: 1:48:16 AM
 */

import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
import java.beans.*;

/**
 * Uue pildi loomise dialoog
 */
public class PildiDialoog extends JDialog
		implements ActionListener, PropertyChangeListener
{

	public static final int VAIKIMISI_K6RGUS = 100;
	public static final int VAIKIMISI_LAIUS = 100;
	private PildiRedaktor pildiRedaktor = null;
	private JTextField laius = null;
	private JTextField k6rgus = null;
	private int laiusInt, k6rgusInt = 1;
	private JOptionPane optionPane;
	private String nuppOk = "Sobib";
	private String nuppCancel = "Loobu";
	private boolean valitud = false;
	private Color taustaVarv = new Color( 255, 255, 255 );
	JButton varviNupp = null;

	public PildiDialoog( PildiRedaktor parent ) throws HeadlessException
	{
		super( parent, true );
		pildiRedaktor = parent;

		setTitle( "Quiz" );
		laius = new JTextField( 10 );
		k6rgus = new JTextField( 10 );
		varviNupp = new JButton( "Taustavrv" );
		varviNupp.setActionCommand( "taust" );
		varviNupp.setBackground( taustaVarv );
		varviNupp.addActionListener( this );

		Object[] array = {"Laius:", laius, "Krgus", k6rgus, "Taustavrv:", varviNupp};
		Object[] options = {nuppOk, nuppCancel};

		optionPane = new JOptionPane( array,
									  JOptionPane.QUESTION_MESSAGE,
									  JOptionPane.YES_NO_OPTION,
									  null,
									  options,
									  options[0] );

		//Make this dialog display it.
		setContentPane( optionPane );

		//Handle window closing correctly.
		setDefaultCloseOperation( DO_NOTHING_ON_CLOSE );
		addWindowListener( new WindowAdapter()
		{
			public void windowClosing( WindowEvent we )
			{
				/*
				 * Instead of directly closing the window,
				 * we're going to change the JOptionPane's
				 * value property.
				 */
				optionPane.setValue( new Integer(
						JOptionPane.CLOSED_OPTION ) );
			}
		} );

		//Register an event handler that puts the text into the option pane.
		laius.addActionListener( this );
		k6rgus.addActionListener( this );
		optionPane.addPropertyChangeListener( this );

	}

	public void actionPerformed( ActionEvent e )
	{
		System.out.println( e.getActionCommand() );
		if ( e.getActionCommand().equals( "taust" ) )
		{
			JColorChooser colorChooser = new JColorChooser( this.taustaVarv );
			taustaVarv = colorChooser.showDialog( this, "Vali uue pildi taustavrv!", taustaVarv );
			varviNupp.setBackground( taustaVarv );
		}
		optionPane.setValue( "test" );
	}

	/** This method reacts to state changes in the option pane. */
	public void propertyChange( PropertyChangeEvent e )
	{
		String prop = e.getPropertyName();
		valitud = false;

		if ( isVisible()
				&& ( e.getSource() == optionPane )
				&& ( JOptionPane.VALUE_PROPERTY.equals( prop ) ||
				JOptionPane.INPUT_VALUE_PROPERTY.equals( prop ) ) )
		{
			Object value = optionPane.getValue();

			if ( value == JOptionPane.UNINITIALIZED_VALUE )
			{
				//ignore reset
				return;
			}

			//Reset the JOptionPane's value.
			//If you don't do this, then if the user
			//presses the same button next time, no
			//property change event will be fired.
			optionPane.setValue(
					JOptionPane.UNINITIALIZED_VALUE );

			if ( nuppOk.equals( value ) )
			{
				try
				{
					k6rgusInt = ( new Integer( k6rgus.getText() ) ).intValue();
					laiusInt = ( new Integer( laius.getText() ) ).intValue();
					clearAndHide();
				}
				catch ( NumberFormatException e1 )
				{
					JOptionPane.showMessageDialog(
							PildiDialoog.this,
							"Vigased numbrid!\n\nProovi veel!",
							"Vigased numbrid",
							JOptionPane.ERROR_MESSAGE );
				}

			}
			else
			{
				//text was invalid
				k6rgus.selectAll();
			}
		}
		else
		{ //user closed dialog or clicked cancel
			k6rgusInt = 1;
			laiusInt = 1;
			clearAndHide();
		}
	}

	public int getK6rgus()
	{
		return k6rgusInt;
	}

	public int getLaius()
	{
		return laiusInt;
	}

	/** This method clears the dialog and hides it. */
	public void clearAndHide()
	{
		laius.setText( null );
		k6rgus.setText( null );
		valitud = true;
		setVisible( false );
	}


	public boolean isValitud()
	{
		return valitud;
	}

	public Color getTaustaVarv()
	{
		return taustaVarv;
	}

}
