/*
 * Created by IntelliJ IDEA.
 * User: karu
 * Date: Mar 19, 2003
 * Time: 2:11:14 AM
 */

import com.sun.image.codec.jpeg.*;
import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
import java.awt.image.*;
import java.io.*;

/**
 * Redaktorisse paigaldatav komponent, milles saab pilti tdelda.
 */
public class PildiKomponent extends JLabel implements Scrollable, MouseListener, MouseMotionListener
{
	public final static String FORMAAT_GIF = "gif";
	public final static String FORMAAT_JPG = "jpg";

	BufferedImage pilt = null;
	Graphics2D piltg = null;
	int maxUnitIncrement = 1;
	String tooReziim = "";
	int vanaX, vanaY, praeguX, praeguY = 0;
	Color aktiivne_varv = new Color( 255, 255, 255 );
	Color taustaVarv = new Color( 0, 0, 0 );
	boolean selectMode = false;
	boolean selected = false;
	int selX, selY, selW, selH;
	Image imageBuffer = null;
	private boolean drawCopyImageToCursor = false;
	private boolean dragging = false;

	public PildiKomponent( int laius, int korgus, Color taustaVarv )
	{
		super();
		pilt = new BufferedImage( laius, korgus, BufferedImage.TYPE_INT_RGB );
		piltg = pilt.createGraphics();
		piltg.setColor( taustaVarv );
		piltg.fillRect( 0, 0, laius, korgus );
		this.taustaVarv = taustaVarv;
		this.setIcon( new ImageIcon( pilt ) );
		this.addMouseListener( this );
		this.addMouseMotionListener( this );
	}

	public void paint( Graphics g )
	{
		g.drawImage( pilt, 0, 0, this );
		if ( selectMode ) drawSelectBox( g );
		if ( selected ) drawSelected( g );
		if ( drawCopyImageToCursor ) drawCopyImage( g );
	}

	private void drawCopyImage( Graphics g )
	{
		g.drawImage( imageBuffer, praeguX - ( vanaX - selX ), praeguY - ( vanaY - selY ), this );
	}

	private void drawSelected( Graphics g )
	{
		g.setColor( Color.white );
		g.setXORMode( getBackground() );
		g.fillRect( selX, selY, selW, selH );
		g.setXORMode( Color.white );
	}

	private void drawSelectBox( Graphics g )
	{
		int dx1, dy1, dx2, dy2;
		dx1 = ( praeguX - vanaX > 0 ) ? vanaX : praeguX;
		dy1 = ( praeguY - vanaY > 0 ) ? vanaY : praeguY;
		dx2 = ( praeguX - vanaX > 0 ) ? praeguX - vanaX : vanaX - praeguX;
		dy2 = ( praeguY - vanaY > 0 ) ? praeguY - vanaY : vanaY - praeguY;
		g.setColor( Color.white );
		g.setXORMode( getBackground() );
		g.drawRect( dx1, dy1, dx2, dy2 );
		g.setXORMode( Color.white );
	}

	public void update( Graphics g )
	{

		paint( g );
	} //hoiab vilkumise eemal

	public void loeFailist( File file ) throws InterruptedException
	{
		Image piltFailist = Toolkit.getDefaultToolkit().getImage( file.getAbsolutePath() );
		MediaTracker mt = new MediaTracker( this );
		mt.addImage( piltFailist, 0 );
		mt.waitForAll();
		pilt = new BufferedImage( piltFailist.getWidth( this ), piltFailist.getHeight( this ), BufferedImage.TYPE_INT_RGB );
		piltg = pilt.createGraphics();
		piltg.drawImage( piltFailist, 0, 0, this );
		this.setIcon( new ImageIcon( pilt ) );
		this.validate();
		repaint();
	}

	public void salvestaFaili( String failiNimi, String tyyp )
	{
		FileOutputStream fos = null;

		if ( tyyp == null )
		{
			tyyp = FileUtil.getExtension( new File( failiNimi ) );
			if ( tyyp == null )
				return;

		}

		if ( FileUtil.getExtension( new File( failiNimi ) ) == null )
			failiNimi += "." + tyyp;

		if ( tyyp.equals( PildiKomponent.FORMAAT_JPG ) )
		{
			try
			{
				fos = new FileOutputStream( failiNimi );
				JPEGCodec.createJPEGEncoder( fos ).encode( this.pilt );
				fos.close();
			}
			catch ( FileNotFoundException e1 )
			{
				e1.printStackTrace();
			}
			catch ( IOException e )
			{
				e.printStackTrace();
			}
			catch ( ImageFormatException e )
			{
				e.printStackTrace();
			}
		}

		if ( tyyp.equals( PildiKomponent.FORMAAT_GIF ) )
		{
			GIFOutputStream gifo = null;
			try
			{
				gifo = new GIFOutputStream( new FileOutputStream( failiNimi ) );
				gifo.write( this.pilt );
				gifo.close();
			}
			catch ( FileNotFoundException e )
			{
				e.printStackTrace();
			}
			catch ( IOException e )
			{
				e.printStackTrace();
			}

		}
	}

	public Dimension getPreferredScrollableViewportSize()
	{
		return getPreferredSize();
	}

	public int getScrollableBlockIncrement( Rectangle visibleRect, int orientation, int direction )
	{
		if ( orientation == SwingConstants.HORIZONTAL )
			return visibleRect.width - maxUnitIncrement;
		else
			return visibleRect.height - maxUnitIncrement;
	}

	public boolean getScrollableTracksViewportHeight()
	{
		return false;
	}

	public boolean getScrollableTracksViewportWidth()
	{
		return false;
	}

	public int getScrollableUnitIncrement( Rectangle visibleRect, int orientation, int direction )
	{
		//Get the current position.
		int currentPosition = 0;
		if ( orientation == SwingConstants.HORIZONTAL )
			currentPosition = visibleRect.x;
		else
			currentPosition = visibleRect.y;

		//Return the number of pixels between currentPosition
		//and the nearest tick mark in the indicated direction.
		if ( direction < 0 )
		{
			int newPosition = currentPosition -
					( currentPosition / maxUnitIncrement ) *
					maxUnitIncrement;
			return ( newPosition == 0 ) ? maxUnitIncrement : newPosition;
		}
		else
		{
			return ( ( currentPosition / maxUnitIncrement ) + 1 ) *
					maxUnitIncrement - currentPosition;
		}

	}

	public void setMaxUnitIncrement( int pixels )
	{
		maxUnitIncrement = pixels;
	}

	public void mouseClicked( MouseEvent e )
	{
	}

	public void mouseEntered( MouseEvent e )
	{
	}

	public void mouseExited( MouseEvent e )
	{
	}

	public void mousePressed( MouseEvent e )
	{

		vanaX = e.getX();
		vanaY = e.getY();

		if ( selected )
		{
			if ( ( vanaX > selX ) && ( vanaY > selY ) && ( vanaX < selX + selW ) && ( vanaY < selY + selH ) )
			{
				drawCopyImageToCursor = true;
				selectMode = false;
			}
			else
			{
				selectMode = true;
				selected = false;
			}
		}
		else
		{
			drawCopyImageToCursor = false;
			selectMode = true;
		}

		dragging = false;
	}

	public void mouseReleased( MouseEvent e )
	{
		selectMode = false;

		int vyx = Math.min( vanaX, e.getX() );
		int vyy = Math.min( vanaY, e.getY() );
		int laius = Math.abs( vanaX - e.getX() );
		int korgus = Math.abs( vanaY - e.getY() );
		laius = laius == 0 ? 1 : laius;
		korgus = korgus == 0 ? 1 : korgus;

		if ( tooReziim.equals( PildiRedaktor.ACT_BTN_RING ) )
		{
			piltg.drawOval( vyx, vyy, laius, korgus );
		}
		else if ( tooReziim.equals( PildiRedaktor.ACT_BTN_KYLIK ) )
		{
			piltg.drawRect( vyx, vyy, laius, korgus );
		}
		else if ( tooReziim.equals( PildiRedaktor.ACT_BTN_RING_TAIDETUD ) )
		{
			piltg.fillOval( vyx, vyy, laius, korgus );
		}
		else if ( tooReziim.equals( PildiRedaktor.ACT_BTN_KYLIK_TAIDETUD ) )
		{
			piltg.fillRect( vyx, vyy, laius, korgus );
		}
		else if ( tooReziim.equals( PildiRedaktor.ACT_BTN_VALIK ) )
		{
			if ( !selected )
			{
				selected = true;
				selX = vyx;
				selY = vyy;
				selH = korgus;
				selW = laius;

				BufferedImage imageBufferBuffer = pilt.getSubimage( selX, selY, selW, selH );
				imageBuffer = createImage( selW, selH );
				imageBuffer.getGraphics().drawImage( imageBufferBuffer, 0, 0, selW, selH, this );

			}
			else
			{
				if ( drawCopyImageToCursor )
				{
					drawCopyImageToCursor = false;
					selected = false;
					int x = praeguX - ( vanaX - selX );
					int y = praeguY - ( vanaY - selY );
					System.out.println( "jooonistan!" );
					piltg.drawImage( imageBuffer, x, y, this );
				}
			}
		}
		repaint();
	}

	public void mouseDragged( MouseEvent e )
	{
		dragging = true;
		praeguX = e.getX();
		praeguY = e.getY();

		if ( drawCopyImageToCursor || selectMode ) ;
		repaint();
	}

	public void mouseMoved( MouseEvent e )
	{
		praeguX = e.getX();
		praeguY = e.getY();
	}

	public String getTooReziim()
	{
		return tooReziim;
	}

	public void setTooReziim( String tooReziim )
	{
		selected = false;
		this.tooReziim = tooReziim;
	}

	public Color getAktiivne_varv()
	{
		return aktiivne_varv;
	}

	public void setAktiivne_varv( Color aktiivne_varv )
	{
		piltg.setColor( aktiivne_varv );
		this.aktiivne_varv = aktiivne_varv;
	}


}
