
import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
import java.io.*;

/**

 * @author Mart Karu
 * @version 1.0
 */
public class PildiRedaktor
		extends JFrame
		implements ActionListener, ItemListener
{

	private static final int EDITOR_LAIUS = 800;
	private static final int EDITOR_K6RGUS = 600;

	public static final String ACT_UUS_PILT = "uuspilt";
	public static final String ACT_AVA = "ava";
	public static final String ACT_SALVESTA = "salvesta";
	public static final String ACT_SALVESTA_UUE_NIMEGA = "salvestanimega";
	public static final String ACT_VALJU = "exit";
	public static final String ACT_VARVIVALIK = "vrvid";

	public static final String ACT_BTN_VALIK = "valik";
	public static final String ACT_BTN_RING = "ring";
	public static final String ACT_BTN_KYLIK = "klik";
	public static final String ACT_BTN_RING_TAIDETUD = "ring_t";
	public static final String ACT_BTN_KYLIK_TAIDETUD = "klik_t";
	public static final String ACT_BTN_JOON = "joon";


	private JTextArea debug = new JTextArea( 5, 60 );

	private String currentPath = "./";
	private String currentFileName;
	private File currentFile;
	private PildiDialoog suuruseDialoog = null;

	PildiKomponent pilt = new PildiKomponent( 400, 400, new Color( 255, 255, 255 ) );
	JScrollPane imageScrollPane = new JScrollPane( pilt );

	private String valitudTooriist = "";
	private JButton eelmineNupp = null;
	private JButton varviNupp = null;

	public PildiRedaktor() throws HeadlessException
	{

		suuruseDialoog = new PildiDialoog( this );
		suuruseDialoog.pack();

		addWindowListener( new WindowAdapter()
		{
			public void windowClosing( WindowEvent e )
			{
				System.exit( 0 );
			}
		} );

		// men
		JMenuBar menuBar = new JMenuBar();
		_genereeriMenyy( menuBar );
		this.setJMenuBar( menuBar );

		// debug-kast
		JScrollPane scrollPane = new JScrollPane( debug );

		//triistad
		JToolBar toolBar = new JToolBar();
		_genereeriNupuriba( toolBar );

		JPanel contentPane = new JPanel();
		contentPane.setLayout( new BorderLayout() );
		contentPane.setPreferredSize( new Dimension( 800, 600 ) );
		contentPane.add( scrollPane, BorderLayout.SOUTH );
		contentPane.add( imageScrollPane, BorderLayout.CENTER );
		contentPane.add( toolBar, BorderLayout.NORTH );
		this.setContentPane( contentPane );

	}

	private void _genereeriNupuriba( JToolBar toolBar )
	{
		JButton button = null;

		button = new JButton( "Valik", new ImageIcon( "images/left.gif" ) );
		button.setToolTipText( "Saab valida pildist osasid" );
		button.setActionCommand( this.ACT_BTN_VALIK );
		button.addActionListener( this );
		toolBar.add( button );

		button = new JButton( "Ring", new ImageIcon( "images/left.gif" ) );
		button.setToolTipText( "joonistab ringi" );
		button.setActionCommand( this.ACT_BTN_RING );
		button.addActionListener( this );
		toolBar.add( button );

		button = new JButton( "Ristklik", new ImageIcon( "images/left.gif" ) );
		button.setToolTipText( "joonistab ristkliku" );
		button.setActionCommand( this.ACT_BTN_KYLIK );
		button.addActionListener( this );
		toolBar.add( button );

		button = new JButton( "Tidetud ring", new ImageIcon( "images/left.gif" ) );
		button.setToolTipText( "joonistab tidetud ringi" );
		button.setActionCommand( this.ACT_BTN_RING_TAIDETUD );
		button.addActionListener( this );
		toolBar.add( button );

		button = new JButton( "tidetud ristklik", new ImageIcon( "images/left.gif" ) );
		button.setToolTipText( "joonistab tidetud ristkliku" );
		button.setActionCommand( this.ACT_BTN_KYLIK_TAIDETUD );
		button.addActionListener( this );
		toolBar.add( button );

		varviNupp = new JButton( "Vrv" );
		varviNupp.setBackground( pilt.getAktiivne_varv() );
		varviNupp.setActionCommand( this.ACT_VARVIVALIK );
		varviNupp.addActionListener( this );
		toolBar.add( varviNupp );
	}

	private void _genereeriMenyy( JMenuBar menuBar )
	{
		JMenu menu = null;

		menu = new JMenu( "Failid" );
		_lisaMenyysse( menu, "Uus pilt", PildiRedaktor.ACT_UUS_PILT );
		_lisaMenyysse( menu, "Avamine ...", PildiRedaktor.ACT_AVA );
		_lisaMenyysse( menu, "Salvesta", PildiRedaktor.ACT_SALVESTA );
		_lisaMenyysse( menu, "Salvesta nimega...", PildiRedaktor.ACT_SALVESTA_UUE_NIMEGA );
		menu.addSeparator();
		_lisaMenyysse( menu, "Vlju", PildiRedaktor.ACT_VALJU );
		menuBar.add( menu );
	}

	private void _lisaMenyysse( JMenu menu, String itemName, String actionName, boolean enabled )
	{
		JMenuItem item = null;
		item = new JMenuItem( itemName );
		item.setActionCommand( actionName );
		item.addActionListener( this );
		item.setEnabled( enabled );
		menu.add( item );
	}


	private void _lisaMenyysse( JMenu menu, String itemName, String actionName )
	{
		_lisaMenyysse( menu, itemName, actionName, true );
	}

	public void mouseClicked( MouseEvent e )
	{
	}

	public void mousePressed( MouseEvent e )
	{

	}

	public void mouseReleased( MouseEvent e )
	{
	}

	public void mouseEntered( MouseEvent e )
	{
	}

	public void mouseExited( MouseEvent e )
	{
	}

	public void actionPerformed( ActionEvent e )
	{
		String action = "";
		JButton clickedButton = null;
		JMenuItem clickedItem = null;
		if ( e.getSource().getClass().getName().equals( "javax.swing.JMenuItem" ) )
		{
			clickedItem = ( JMenuItem ) e.getSource();
			debug.append( clickedItem.getActionCommand() + "\n" );

			action = clickedItem.getActionCommand();
		}

		if ( e.getSource().getClass().getName().equals( "javax.swing.JButton" ) )
		{
			clickedButton = ( JButton ) e.getSource();
			debug.append( clickedButton.getActionCommand() + "\n" );
			action = clickedButton.getActionCommand();
		}

		//vljumine
		if ( action.equals( PildiRedaktor.ACT_VALJU ) )
		{
			System.exit( 0 );
		}

		if ( action.equals( PildiRedaktor.ACT_AVA ) )
		{
			JFileChooser fileChooser = new JFileChooser( this.currentPath );
			fileChooser.setAcceptAllFileFilterUsed( false );
			fileChooser.setFileFilter( new ImageFilter() );
			int fcResult = fileChooser.showOpenDialog( this );
			if ( fcResult == fileChooser.APPROVE_OPTION )
			{
				this.currentFile = fileChooser.getSelectedFile();
				this.currentFileName = currentFile.getName();
				this.currentPath = currentFile.getPath();
			}
			try
			{
				pilt.loeFailist( this.currentFile );
				imageScrollPane.revalidate();
			}
			catch ( InterruptedException e1 )
			{
				e1.printStackTrace();
			}
		}

		if ( action.equals( PildiRedaktor.ACT_SALVESTA ) )
		{
			if ( this.currentFile == null )
				action = PildiRedaktor.ACT_SALVESTA_UUE_NIMEGA;
			else
			{
				pilt.salvestaFaili( this.currentFile.getAbsolutePath(), FileUtil.getExtension( this.currentFile ) );
			}
		}

		if ( action.equals( PildiRedaktor.ACT_SALVESTA_UUE_NIMEGA ) )
		{
			JFileChooser fileChooser = new JFileChooser( this.currentPath );
			fileChooser.setMultiSelectionEnabled( false );
			fileChooser.addChoosableFileFilter( new SaveImageFilter( PildiKomponent.FORMAAT_GIF, "GIF pilt" ) );
			fileChooser.addChoosableFileFilter( new SaveImageFilter( PildiKomponent.FORMAAT_JPG, "JPEG pilt" ) );
			switch ( fileChooser.showSaveDialog( this ) )
			{
				case JFileChooser.APPROVE_OPTION:
					{
						this.currentFile = fileChooser.getSelectedFile();
						String extension = ( ( SaveImageFilter ) fileChooser.getFileFilter() ).getFileExtension();
						this.pilt.salvestaFaili( this.currentFile.getAbsolutePath(), extension );
						this.currentFileName = this.currentFile.getName();
						this.currentPath = this.currentFile.getAbsolutePath();
						break;
					}
				default:
					break;

			}
		}

		if ( action.equals( PildiRedaktor.ACT_UUS_PILT ) )
		{
			suuruseDialoog.setLocationRelativeTo( this );
			suuruseDialoog.setVisible( true );
			if ( suuruseDialoog.isValitud() )
			{
				pilt = new PildiKomponent( suuruseDialoog.getLaius(), suuruseDialoog.getK6rgus(), suuruseDialoog.getTaustaVarv() );
				imageScrollPane.setViewportView( pilt );
				imageScrollPane.revalidate();
			}
			this.currentFile = null;
			this.currentFileName = "";
		}

		if (
				action.equals( PildiRedaktor.ACT_BTN_VALIK ) ||
				action.equals( PildiRedaktor.ACT_BTN_RING ) ||
				action.equals( PildiRedaktor.ACT_BTN_KYLIK ) ||
				action.equals( PildiRedaktor.ACT_BTN_RING_TAIDETUD ) ||
				action.equals( PildiRedaktor.ACT_BTN_KYLIK_TAIDETUD )
		)
		{
			toggleButton( action, clickedButton );
			pilt.setTooReziim( action );
		}

		if ( action.equals( PildiRedaktor.ACT_VARVIVALIK ) )
		{
			JColorChooser colorChooser = new JColorChooser( pilt.getAktiivne_varv() );
			Color uusVarv = colorChooser.showDialog( this, "Vali sobilik vrv!", pilt.getAktiivne_varv() );
			pilt.setAktiivne_varv( uusVarv );
			varviNupp.setBackground( uusVarv );
		}
	}

	private void toggleButton( String action, JButton clickedButton )
	{
		if ( valitudTooriist.equals( action ) )
		{
			return;
		}
		else
		{
			if ( eelmineNupp != null )
				eelmineNupp.setBackground( eelmineNupp.getParent().getBackground() );
			valitudTooriist = action;
			clickedButton.setBackground( Color.ORANGE );
			eelmineNupp = clickedButton;
		}
	}

	public void mouseDragged( MouseEvent e )
	{
	}

	public void mouseMoved( MouseEvent e )
	{
	}

	public void itemStateChanged( ItemEvent e )
	{
		String newline = "\n";
		JMenuItem source = ( JMenuItem ) ( e.getSource() );
		String s = "Item event detected."
				+ newline
				+ "    Event source: " + source.getText()
				+ " (an instance of " + getClassName( source ) + ")"
				+ newline
				+ "    New state: "
				+ ( ( e.getStateChange() == ItemEvent.SELECTED ) ?
				"selected" : "unselected" );
		debug.append( s + newline );
	}


	// Returns just the class name -- no package info.
	protected String getClassName( Object o )
	{
		String classString = o.getClass().getName();
		int dotIndex = classString.lastIndexOf( "." );
		return classString.substring( dotIndex + 1 );
	}

	public static void main( String[] arg )
	{
		PildiRedaktor pildiRedaktor = new PildiRedaktor();
		pildiRedaktor.setTitle( "Pildiredaktor" );
		pildiRedaktor.setSize( PildiRedaktor.EDITOR_LAIUS, PildiRedaktor.EDITOR_K6RGUS );
		pildiRedaktor.setVisible( true );
	}

	public String getValitudTooriist()
	{
		return valitudTooriist;
	}

}
