package GPClient;

import java.awt.*;
import java.awt.image.*;
import java.lang.*;
import java.awt.Graphics2D;
import java.awt.event.*;

/**
 * <p>Title: </p>
 * <p>Description: </p>
 * <p>Copyright: Copyright (c) 2000</p>
 * <p>Company: </p>
 * @author not attributable
 * @version 1.0
 */

public class BoardGraphics extends Canvas {

private Image bufferImage;
private BufferedImage boardImage,tileImage,tileActiveImage;
private Graphics2D buffer;
private int[][] board = new int[4][4];

  public BoardGraphics() {
    // mängulaua pildi joonistamine
    boardImage = new BufferedImage(201,201,BufferedImage.TYPE_INT_BGR);
    buffer = boardImage.createGraphics();
    buffer.setColor(Color.white);
    buffer.fillRect(0,0,201,201);
    buffer.setColor(Color.black);
    buffer.drawRect(0,0,200,200);
    buffer.drawLine(50,0,50,200);
    buffer.drawLine(100,0,100,200);
    buffer.drawLine(150,0,150,200);
    buffer.drawLine(0,50,200,50);
    buffer.drawLine(0,100,200,100);
    buffer.drawLine(0,150,200,150);
    buffer = null;
    // mängunupu pildi joonistamine
    tileImage = new BufferedImage(48,48,BufferedImage.TYPE_INT_BGR);
    buffer = tileImage.createGraphics();
    buffer.setColor(Color.white);
    buffer.fillRect(0,0,48,48);
    buffer.setColor(Color.red);
    buffer.fillOval(11,11,26,26);
    buffer = null;
    // aktiivse mängunupu pildi joonistamine
    tileActiveImage = new BufferedImage(48,48,BufferedImage.TYPE_INT_BGR);
    buffer = tileActiveImage.createGraphics();
    buffer.drawImage(tileImage,0,0,this);
    buffer.setColor(Color.black);
    buffer.drawOval(11,11,26,26);
    buffer = null;

    fillBoard();
    this.addMouseListener(new boardMouseAdapter());
  }

  public BoardGraphics(GraphicsConfiguration p0) {
    super(p0);
  }

  private void fillBoard(){
    int x;
    int y;
    for(x=0;x<4;x++){
      for(y=0;y<4;y++){
        board[x][y]=1;
      }
    }
  }

  public void removeSelected(){
    int x;
    int y;
    for(x=0;x<4;x++){
      for(y=0;y<4;y++){
        if(board[x][y]==3){
          board[x][y]=0;
        }
      }
    }
  }

  public void deserializeBoard(String bs){
    int x,y,count;
    count = 1;
    for(x=0;x<4;x++){
      for(y=0;y<4;y++){
        board[x][y]=Integer.parseInt(bs.substring(count,count+1));
        count = count +2;
      }
    }
  }

  public String serializeBoard(){
    String bs = "board:";
    int x,y;
    for(x=0;x<4;x++){
      for(y=0;y<4;y++){
          bs = bs+"."+board[x][y];
      }
    }
    return bs;
  }

  public void drawBoard(){
    bufferImage = createImage(201,201);
    buffer = (Graphics2D) bufferImage.getGraphics();
    buffer.drawImage(boardImage,0,0,this);
    int x;
    int y;
    for(x=0;x<4;x++){
      for(y=0;y<4;y++){
        if( board[x][y]==1){
          buffer.drawImage(tileImage,x*50+1,y*50+1,this);
        }
        if( board[x][y]==3){
          buffer.drawImage(tileActiveImage,x*50+1,y*50+1,this);
        }
      }
    }
    repaint();
  }

  public void paint(Graphics g){update(g);}

  public void update(Graphics g){
      if(bufferImage!=null){this.getGraphics().drawImage(bufferImage,0,0,this);}
  }

  private int[] pixelToBoard(int x, int y){
    int boardX = (int) Math.floor(x/50);
    int boardY = (int) Math.floor(y/50);
    int[] boardXY= new int[2];
    boardXY[0]=boardX;
    boardXY[1]=boardY;
    return boardXY;
  }


  private int getSelectCount() {
    int count=0;
    int x;
    int y;
    for(x=0;x<4;x++){
      for(y=0;y<4;y++){
        if(board[x][y]==3){
          count++;
        }
      }
    }
    return count;
  }

  public int countTiles() {
    int count=0;
    int x;
    int y;
    for(x=0;x<4;x++){
      for(y=0;y<4;y++){
        if(board[x][y]==1){
          count++;
        }
      }
    }
    return count;
  }


  private boolean isSelect(int col,int row){
    if( board[col][row]==3){
      return true;
    }
    return false;
  }

  private boolean isCounter(int col, int row){
    if( board[col][row]==1){
      return true;
    }
    return false;
  }

  private boolean isValidSelect(int[] boardXY) {
    int col = boardXY[0];
    int row = boardXY[1];
     if (!isCounter(col,row)||getSelectCount()>=4) return false ;
     for (int i=0; i<4; i++) {
        for (int j=0; j<4; j++) {
           if (isSelect(i,j)) {
              // check if adjacent in column
              if (col==i) {
                 if (row==0) {
                    if (!isSelect(col,row+1)) return false ;
                 }
                 else if (row==3) {
                    if (!isSelect(col,row-1)) return false ;
                 }
                 else
                    if ( (!isSelect(col,row+1))&
                         (!isSelect(col,row-1)) ) return false ;
              }
              // check if adjacent in row
              else if (row==j) {
                 if (col==0) {
                    if (!isSelect(col+1,row)) return false ;
                 }
                 else if (col==3) {
                    if (!isSelect(col-1,row)) return false ;
                 }
                 else
                    if ( (!isSelect(col+1,row))&
                         (!isSelect(col-1,row)) ) return false ;
              // not on same row or column
              } else return false ;
           }
        }
     }
     return true ;
  }


  // hiire kuular
  class boardMouseAdapter extends java.awt.event.MouseAdapter {
    boardMouseAdapter() {
      super();
    }
    public void mouseClicked(MouseEvent e) {
      System.out.println(e.getX());
      System.out.println(e.getY());
      int[] boardXY = pixelToBoard(e.getX(),e.getY());
      if(isValidSelect(boardXY)){
        board[boardXY[0]][boardXY[1]]=3;
      }
      drawBoard();
    }
  }

}
