package GPClient;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import java.net.*;
import java.io.*;
import java.util.*;

/**
 * <p>Title: </p>
 * <p>Description: </p>
 * <p>Copyright: Copyright (c) 2000</p>
 * <p>Company: </p>
 * @author not attributable
 * @version 1.0
 */

public class Game extends JFrame implements Runnable{

  private InetAddress serverIP;
  private int serverPort;
  private Socket s;
  private DataInputStream din;
  private DataOutputStream dout;

  private Hashtable opengames = new Hashtable();
  private Vector listvector = new Vector();

  private boolean THIS_THREAD_ACTIVE;

  Thread gamethread;

  JPanel contentPane;
  JMenuBar jMenuBar1 = new JMenuBar();
  JMenu jMenuFile = new JMenu();
  JMenu jMenuHelp = new JMenu();
  JMenuItem jMenuHelpAbout = new JMenuItem();
  JMenuItem jMenuItem1 = new JMenuItem();
  JMenuItem jMenuItem2 = new JMenuItem();
  JMenuItem jMenuFileConnect = new JMenuItem();
  JMenuItem jMenuFileExit = new JMenuItem();
  CardLayout cardLayout1 = new CardLayout();
  JPanel jPanel1 = new JPanel();
  JList jList1 = new JList();
  GridBagLayout gridBagLayout1 = new GridBagLayout();
  JButton jButton1 = new JButton();
  JButton jButton2 = new JButton();
  JLabel jLabel1 = new JLabel();
  JPanel jPanel2 = new JPanel();
  JPanel jPanel3 = new JPanel();
  BoardGraphics boardGraphics1 = new BoardGraphics();
  JButton jButton3 = new JButton();
  GridBagLayout gridBagLayout2 = new GridBagLayout();

  //Construct the frame
  public Game() {
    gamethread = new Thread(this);
    enableEvents(AWTEvent.WINDOW_EVENT_MASK);
    try {
      jbInit();
    }
    catch(Exception e) {
      e.printStackTrace();
    }
  }

  //Component initialization
  private void jbInit() throws Exception  {

    // Menüü koostamine
    jMenuFile.setText("File");
    jMenuHelp.setText("Help");
    jMenuFileConnect.setText("Connect");
    jMenuFileExit.setText("Exit");
    jMenuHelpAbout.setText("About");
    jMenuFileExit.addActionListener(new Game_jMenuFileExit_ActionAdapter(this));
    jMenuHelpAbout.addActionListener(new Game_jMenuHelpAbout_ActionAdapter(this));
    jMenuFileConnect.addActionListener(new Game_jMenuFileConnect_ActionAdapter(this));
    jList1.setBorder(BorderFactory.createLineBorder(Color.black));
    jList1.setOpaque(true);
    jButton1.setHorizontalAlignment(SwingConstants.CENTER);
    jButton1.setHorizontalTextPosition(SwingConstants.CENTER);
    jButton1.setSelected(false);
    jButton1.setText("Start New Game");
    jButton1.addActionListener(new Game_jButton1_actionAdapter(this));
    jButton2.setToolTipText("");
    jButton2.setText("Join Open Game");
    jButton2.addActionListener(new Game_jButton2_actionAdapter(this));
    jLabel1.setOpaque(false);
    jLabel1.setText("Open Games List");
    jPanel3.setLayout(gridBagLayout2);
    jButton3.setToolTipText("");
    jButton3.setText("Make Your Move");
    jButton3.addActionListener(new Game_jButton3_actionAdapter(this));
    jMenuFile.add(jMenuFileConnect);
    jMenuFile.add(jMenuFileExit);
    jMenuHelp.add(jMenuHelpAbout);
    jMenuBar1.add(jMenuFile);
    jMenuBar1.add(jMenuHelp);

    jList1.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);

    jPanel1.setLayout(gridBagLayout1);
    contentPane = (JPanel) this.getContentPane();

    jPanel1.add(jList1,                          new GridBagConstraints(0, 1, 1, 7, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 126, 162));
    jPanel1.add(jButton1,                    new GridBagConstraints(1, 1, 6, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(10, 10, 10, 0), 0, 0));
    jPanel1.add(jButton2,      new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(10, 10, 10, 0), 0, 0));
    jPanel1.add(jLabel1,    new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 5, 4));

    //boardGraphics1.setBounds(0,0,201,201);
    //jPanel3.add(boardGraphics1,"South");

    contentPane.setLayout(cardLayout1);
    contentPane.add(jPanel2, "jPanel2");
    contentPane.add(jPanel1, "jPanel1");
    contentPane.add(jPanel3, "jPanel3");

    jPanel3.add(boardGraphics1,                    new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0
            ,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(10, 93, 0, 93), 201, 201));
    jPanel3.add(jButton3,      new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(5, 0, 10, 0), 0, 0));
    cardLayout1.show(contentPane,"jPanel3");
    //boardGraphics1.drawBoard();


    this.setSize(new Dimension(400, 300));
    this.setTitle("TacTix");
    this.setJMenuBar(jMenuBar1);
  }

  public void setServerIP(InetAddress ip){
    serverIP = ip;
  }

  public void setServerPort(int port){
    serverPort = port;
  }

  protected void connectToServer(){
    try{
      s = new Socket(serverIP,serverPort);
      din = new DataInputStream(s.getInputStream());
      dout = new DataOutputStream(s.getOutputStream());
      dout.writeUTF("get-opengames");
      System.out.println("msg sent to server");
      THIS_THREAD_ACTIVE = true;
      gamethread.start();
    }
    catch(IOException i){
      i.printStackTrace();
    }
  }

  public void run(){
    System.out.println("thread started");
    String servermessage;
    while(THIS_THREAD_ACTIVE){
      try{
        servermessage = din.readUTF();
        if(servermessage.equalsIgnoreCase("Opengames-LIST")){
          int i = 1;
          servermessage = din.readUTF();
          while( !servermessage.equalsIgnoreCase("END") ){
            System.out.println(servermessage);
            listvector.add("Game "+i);
            opengames.put("Game "+i,servermessage);
            servermessage = din.readUTF();
          }
          jList1.setListData(listvector);
          cardLayout1.show(contentPane,"jPanel1");
        }
        if(servermessage.equalsIgnoreCase("Game started")){
          showGameBoard();
          jButton3.setEnabled(false);
          dout.writeUTF("start");
        }
        if(servermessage.equalsIgnoreCase("your turn")){
         showGameBoard();
         jButton3.setEnabled(true);
        }
        if(servermessage.regionMatches(0,"board:",0,6)){
          String bs = servermessage.substring(6);
          boardGraphics1.deserializeBoard(bs);
          boardGraphics1.drawBoard();
        }
        if(servermessage.equalsIgnoreCase("game lost")){
          showGameOver("You Lost!");
        }
      }
      catch(IOException e){
        e.printStackTrace();
      }
      finally{
      }
    }
  }

  private void showGameBoard(){
    cardLayout1.show(contentPane,"jPanel3");
    boardGraphics1.drawBoard();
  }

  private void showGameOver(String text){
    GameOverDialog dlg = new GameOverDialog(null,"Game Over",false,text);
    Dimension dlgSize = dlg.getPreferredSize();
    Dimension frmSize = getSize();
    Point loc = getLocation();
    dlg.setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
    dlg.show();
  }

// --------- EVENT processing ---------------------------------------

  //File | Exit action performed
  public void jMenuFileExit_actionPerformed(ActionEvent e) {
    try{
      if(s != null){
        s.close();
      }
    }
    catch(IOException ie){
      ie.printStackTrace();
    }
    THIS_THREAD_ACTIVE = false;
    System.exit(0);
  }

  //File | Connect action performed
  public void jMenuFileConnect_actionPerformed(ActionEvent e) {
   ConnectDialog dlg = new ConnectDialog(this,"Connect To Server",true);
   Dimension dlgSize = dlg.getPreferredSize();
   Dimension frmSize = getSize();
   Point loc = getLocation();
   dlg.setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
   //dlg.setModal(true);
   //dlg.pack();
   dlg.show();
 }

  //Help | About action performed
  public void jMenuHelpAbout_actionPerformed(ActionEvent e) {
    Game_AboutBox dlg = new Game_AboutBox(this);
    Dimension dlgSize = dlg.getPreferredSize();
    Dimension frmSize = getSize();
    Point loc = getLocation();
    dlg.setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
    dlg.setModal(true);
    dlg.pack();
    dlg.show();
  }

  //Overridden so we can exit when window is closed
  protected void processWindowEvent(WindowEvent e) {
    super.processWindowEvent(e);
    if (e.getID() == WindowEvent.WINDOW_CLOSING) {
      jMenuFileExit_actionPerformed(null);
    }
  }

  // Start new game button
  void jButton1_actionPerformed(ActionEvent e) {
    try{
      dout.writeUTF("new");
    }
    catch(IOException i){
      i.printStackTrace();
    }
  }

  void jButton2_actionPerformed(ActionEvent e) {
    int nr = jList1.getSelectedIndex()+1;
    String gameID = (String) opengames.get( "Game "+nr );
    try{
      dout.writeUTF("join"+gameID);
      showGameBoard();
      jButton3.setEnabled(false);
    }
    catch(IOException i){
      i.printStackTrace();
    }
  }

  void jButton3_actionPerformed(ActionEvent e) {
    boardGraphics1.removeSelected();
    if(boardGraphics1.countTiles() == 1){
      try{
        showGameOver("You Win!");
        dout.writeUTF("game lost");
      }
      catch(IOException i){
        i.printStackTrace();
      }
    }
    String board = boardGraphics1.serializeBoard();
    jButton3.setEnabled(false);
    try{
      dout.writeUTF(board);
      dout.writeUTF("turn");
    }
    catch(IOException i){
      i.printStackTrace();
    }
    showGameBoard();
  }

}



// ---------------------- Action classes ------------------------------------- //

class Game_jMenuHelpAbout_ActionAdapter implements ActionListener {
  Game adaptee;

  Game_jMenuHelpAbout_ActionAdapter(Game adaptee) {
    this.adaptee = adaptee;
  }
  public void actionPerformed(ActionEvent e) {
    adaptee.jMenuHelpAbout_actionPerformed(e);
  }
}

class Game_jMenuFileExit_ActionAdapter implements ActionListener {
  Game adaptee;

  Game_jMenuFileExit_ActionAdapter(Game adaptee) {
    this.adaptee = adaptee;
  }
  public void actionPerformed(ActionEvent e) {
    adaptee.jMenuFileExit_actionPerformed(e);
  }
}

class Game_jMenuFileConnect_ActionAdapter implements ActionListener {
  Game adaptee;

  Game_jMenuFileConnect_ActionAdapter(Game adaptee) {
    this.adaptee = adaptee;
  }
  public void actionPerformed(ActionEvent e) {
    adaptee.jMenuFileConnect_actionPerformed(e);
  }
}

class Game_jButton1_actionAdapter implements java.awt.event.ActionListener {
  Game adaptee;

  Game_jButton1_actionAdapter(Game adaptee) {
    this.adaptee = adaptee;
  }
  public void actionPerformed(ActionEvent e) {
    adaptee.jButton1_actionPerformed(e);
  }
}

class Game_jButton2_actionAdapter implements java.awt.event.ActionListener {
  Game adaptee;

  Game_jButton2_actionAdapter(Game adaptee) {
    this.adaptee = adaptee;
  }
  public void actionPerformed(ActionEvent e) {
    adaptee.jButton2_actionPerformed(e);
  }
}

class Game_jButton3_actionAdapter implements java.awt.event.ActionListener {
  Game adaptee;

  Game_jButton3_actionAdapter(Game adaptee) {
    this.adaptee = adaptee;
  }
  public void actionPerformed(ActionEvent e) {
    adaptee.jButton3_actionPerformed(e);
  }
}
