import OFS, Globals
from Globals import Acquisition, Persistent
import AccessControl
from Acquisition import aq_base, aq_inner, aq_parent, Explicit
from Products.PageTemplates.PageTemplateFile import PageTemplateFile
from Products.CMFCore.Skinnable import SkinnableObjectManager



class OntoEkodanik(
   SkinnableObjectManager, 
   Persistent, 
   OFS.Folder.Folder,
   Explicit):
   "Main class"
   usernames=[]
   defaultAnswerValue=0
   qnr=0
   meta_type="OntoEkodanik"
   security = AccessControl.ClassSecurityInfo()
   security.declareObjectPublic()
   manage_options = OFS.Folder.Folder.manage_options
   wikifolderurl="zwiki/"

   def manage_afterAdd(self, item, container):
        self.setupSkins()
        self.manage_permission('View', ('Authenticated',) ,0)

   security.declarePrivate('setupSkins')
   def setupSkins(self):
        """ setup skins system """
        from Products.CMFCore.utils import manage_addTool
        add_tool = self.manage_addProduct['CMFCore'].manage_addTool
        add_tool('CMF Skins Tool', None)
        sk_tool = getattr(self, self.getSkinsFolderName())
        sk_tool.manage_addFolder('default_custom', 'Customize pages here for default skin')
        paths = "main, default_custom"
        sk_tool.addSkinSelection('default', paths, make_default = 1)
        from Products.CMFCore.DirectoryView import addDirectoryViews
        addDirectoryViews(sk_tool, 'skins', globals())


   def getSkinsFolderName(self):
        return "portal_skins"


   def index_html(self):
      "index file"
      return self.mainframe()

   def getNewQuestionID(self):
      "for creating question objects"
      self.qnr+=1
      return "q"+str(self.qnr)
      
   def question_add_form_handler(self, REQUEST):
      "Adding question"
      self.createNewQuestion(getattr(REQUEST, 'qtext'), getattr(REQUEST, 'qlink', ""))
      REQUEST.RESPONSE.redirect('datalist_table?utext=1')

   def createNewQuestion(self, text, link=""):
      "create"
#      print text, link
      q=OntoQuestion(text, link)
      q.id=self.getNewQuestionID()
      self._setObject(q.id, q)
      return q.id
   
   def answer_add_form_handler(self, REQUEST):
      "Adding answers"
      for q in self.getQuestions():
         qa=getattr(REQUEST, q.id, None)
         if qa and len(qa[0])>0:
            self.saveQuestionAnswer(REQUEST, q.id, qa[0], qa[1])
      REQUEST.RESPONSE.redirect('datalist_table?utext=1')
   
   def saveQuestionAnswer(self, REQUEST, qid, value, text):
      "Save answer"
      uname=str(REQUEST.AUTHENTICATED_USER)
      if uname not in self.usernames: 
        self.usernames.append(uname)
        self.usernames=self.usernames
      q=getattr(self, qid)
      if hasattr(q, uname): q._delObject(uname)
      if not value=="xx":
        a=OntoAnswer(float(value), text)
        a.id=uname
        q._setObject(a.id, a)
   
   def getQuestions(self):
      "Question objects array"
      return self.objectValues('OntoQuestion')
      
   def getUserNames(self):
      "logged usernames list"
      return self.usernames
      
   def getDefaultAnswerValue(self):
      "getter"
      return self.defaultAnswerValue
      
   def getQuestionAverageValue(self, qid):
      "arithmetical average"
      s=0
      q=getattr(self, qid)
      for uname in self.usernames:
         s+=q.getUserAnswerValue(username=uname)
      return float(s)/len(self.usernames)
      
   def questionCompare(self, q1, q2):
      "compares by average value"
      d=(self.getQuestionAverageValue(q2.id)-self.getQuestionAverageValue(q1.id))
      if d<0: return -1
      if d>0: return 1
      return 0
      
   def getSortedQuestions(self):
      "Sorted by average value"
      qs=self.getQuestions()
      qs.sort(self.questionCompare)
      return qs
      
   def getUnansweredQuestionList(self, REQUEST):
      "list of questions, which current user not answered yet"
      t=[]
      for q in self.getQuestions():
         if not q.isAnsweredByCurrentUser(REQUEST):
            t.append(q)
      return t

   def getAnsweredQuestionList(self, REQUEST):
      "list of questions, which current user answered"
      t=[]
      for q in self.getSortedQuestions():
         if q.isAnsweredByCurrentUser(REQUEST):
            t.append(q)
      return t

   def getWikiMainURL(self):
       "Place where Wiki starts"
       #return "zwiki/"
       return self.wikifolderurl
       
   def setWikiMainURL(self, newurl):
       "change location"
       self.wikifolderurl=newurl;
       return newurl
   
class OntoQuestion(
     Persistent,
     OFS.Folder.Folder,
     OFS.SimpleItem.Item,
     AccessControl.Role.RoleManager
   ):
   "Question data"
   text="xxx"
   link=""
   meta_type="OntoQuestion"
   
   def __init__(self, text, link=None):
      "Constructor"
      self.text=text
      if link:
         self.link=link
   
   def getText(self):
      "getter"
      return self.text
      
   def getLink(self):
      "getter"
      return self.link
            
   def getUserAnswerValue(self, REQUEST=None, username=None):
      "User answer"
      if REQUEST: username=str(REQUEST.AUTHENTICATED_USER)
      uanswer=getattr(self, username, None)
      if uanswer:
         return uanswer.getAnswerValue()
      return self.getDefaultAnswerValue()
      
   def getQuestionWikiURL(self):
      "Place to write wiki page"
      return self.getWikiMainURL()+self.id

   def getUserAnswerText(self, REQUEST=None, username=None):
      "User answer"
      if REQUEST: username=str(REQUEST.AUTHENTICATED_USER)
      uanswer=getattr(self, username, None)
      if uanswer:
         return uanswer.getAnswerText()
      return ""
      
   def isAnsweredByCurrentUser(self, REQUEST):
      "getter"
      uname=str(REQUEST.AUTHENTICATED_USER)
      return hasattr(self, uname)


class OntoAnswer(
     Persistent,
     OFS.SimpleItem.Item,
     AccessControl.Role.RoleManager
   ):
   "User answer data"
   answertext="xx"
   answervalue=0.0
   meta_type="OntoAnswer"
   
   def __init__(self, value, text=None):
     "constructor"
     self.answervalue=value
     self.answertext=text
     
   def getAnswerText(self):
     "getter"
     return self.answertext
     
   def getAnswerValue(self):
     "getter"
     return self.answervalue

     


def manage_addOntoEkodanik(self, REQUEST, id):
    """ instantiate """
    ob = OntoEkodanik(id)
    self._setObject(id, ob)
    if REQUEST:
        return self.manage_main(self, REQUEST)
#        return ob.index_html()

manage_addOntoEkodanikForm = PageTemplateFile('skins/addOntoEkodanikForm.pt', globals())

