import javax.swing.*;
import javax.swing.table.*;
import javax.swing.tree.*;
import java.awt.*;
/**
*  Main application
*/
public class OntoApp extends JApplet{
   boolean isStandalone=false;
   OntoData od=new OntoData();
   OntoPanel op=new OntoPanel();
   OntoListener ol=new OntoListener();
   OntoTableModel ot=new OntoTableModel(this);
   OntoTreeModel otm=new OntoTreeModel(this);
   OntoTreeEditorComponent otec=new OntoTreeEditorComponent(this);
   OntoTreeRendererComponent otrc=new OntoTreeRendererComponent(this);
   JScrollPane osPanel;
   OntoSliders os=new OntoSliders(this);
   OntoDataFrame odf;
   JButton b1=new JButton("RandomIterate");
   JTextField btf1=new JTextField("1000");
   JButton b2=new JButton("RandomCoordinates");
   JToggleButton b3=new JToggleButton("Continous calculating");
   JButton b4=new JButton("Options");
   Choice fileChoice=new Choice();
   JTable table;
   JScrollPane tablePanel;
   JTree tree;
   
   JScrollPane treePanel;
   JPanel buttonPanel=new JPanel(new GridLayout());

   public OntoApp(){
     this(false);
   }

   public OntoApp(boolean standalone){
      this.isStandalone=standalone;
      getContentPane().setLayout(new BorderLayout());
      odf=new OntoDataFrame(this);
      if(isStandalone){od.readDataFromFile("Creatures2.txt");}
      else{od.readSampleData();}
      od.normalizeData();
      od.randomCoordinates();
      op.od=od;
      op.oa=this;
      ol.oa=this;
//      ot.oa=this;
      os.initialize();
//      buttonPanel.add(b1);
//      buttonPanel.add(btf1);
//      buttonPanel.add(b2);
//      buttonPanel.add(b3);
//      buttonPanel.add(b4);
//      buttonPanel.add(fileChoice);
      JLabel label1=new JLabel("My perspective");
      JLabel label2=new JLabel("Political map");
      Font f1=new Font("Times new roman", Font.BOLD, 25);
      label1.setFont(f1);
      label2.setFont(f1);
      buttonPanel.add(label1);
      buttonPanel.add(label2);
      b1.addActionListener(ol);
      b2.addActionListener(ol);
      b3.addActionListener(ol);
      b4.addActionListener(ol);
      fileChoice.addItemListener(ol);
      op.addMouseListener(ol);
      op.addMouseMotionListener(ol);
      //os.setSize(100, 100);
      reloadLayout();
   }
   public void init(){
     ol.filenamesToChoice();
     addTable();
//     addTree();
     reloadLayout();
   }
   
   void reloadLayout(){
      getContentPane().removeAll();
      getContentPane().add(buttonPanel, BorderLayout.NORTH);
      getContentPane().add(op, BorderLayout.CENTER);
      addTable();
      if(odf.bzappslidersview.isSelected()){
       osPanel=new JScrollPane(os);
       osPanel.setPreferredSize(new Dimension(300, 500));
//       osPanel.setPreferredSize(os.getPreferredSize());
       getContentPane().add(osPanel, BorderLayout.WEST);
       os.validate();
       osPanel.validate();
 //       getContentPane().add(new JScrollPane(os, 
 //        JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED, 
 //        JScrollPane.HORIZONTAL_SCROLLBAR_NEVER), BorderLayout.WEST);
      } else {
         addTree();
      }
//      invalidate();
      validate();
      repaint();
   }
   
   void addTree(){
       if(treePanel!=null){getContentPane().remove(treePanel);}
       //otm=new OntoTreeModel(this);
       tree=new JTree(otm);
       tree.addMouseListener(otm);
//       tree.setEditable(true);
       tree.addTreeSelectionListener(otm);
       tree.setCellEditor(otec);
       tree.setCellRenderer(otrc);
       tree.getSelectionModel().setSelectionMode(TreeSelectionModel.DISCONTIGUOUS_TREE_SELECTION);
       treePanel=new JScrollPane(tree);
       treePanel.setPreferredSize(new Dimension(300, 300));
       if(!odf.bzappslidersview.isSelected()){
          getContentPane().add(treePanel, BorderLayout.WEST);
       }
       tree.revalidate();
       validate();   
   }
   
   void addTable(){
      if(tablePanel!=null){getContentPane().remove(tablePanel);}
      table=new JTable(ot);
      table.setCellEditor(new DefaultCellEditor(new JCheckBox()));
     // c2.setCellRenderer(new DefaultTableCellRenderer(new JCheckBox()));
      //table.setCellSelectionEnabled(true);
      //table.setColumnSelectionAllowed(true);
      table.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
//      TableColumn lockColumn=table.getColumnModel().getColumn(od.parameters.length+2+1);
//      lockColumn.setCellEditor(new DefaultCellEditor(new JCheckBox()));
      int twidth=0;
      if(od.data.length>0){
         twidth=(od.data[0].length+4)*50;
      }
      if(twidth<700){twidth=700;}
      else{
      table.setAutoResizeMode(JTable.AUTO_RESIZE_OFF);
      }
      if(odf.bzapptableview.isSelected()){
        tablePanel=new JScrollPane(table, JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED, 
         JScrollPane.HORIZONTAL_SCROLLBAR_AS_NEEDED);
        
        tablePanel.setPreferredSize(new Dimension(twidth, 150));
        getContentPane().add(tablePanel, BorderLayout.SOUTH);
      }
//      table.setPreferredSize(new Dimension(twidth, od.data.length*20));
//      table.setSize(2000, 2000);
//      table.revalidate();
      validate();   
      table.addMouseListener(ot);
   }
   public static void main(String[] arg){
      JFrame f=new JFrame("OntoApp");
      OntoApp oa=new OntoApp(true);
      oa.init();
      f.getContentPane().add(oa);
      f.setSize(700, 600);
      f.setVisible(true);
   }
}