import java.io.*;
import java.util.*;
/**
* Data model of application. Other classes use data holded here. If runned 
* from main, then can make calculations self without graphics.
*/
public class OntoData{
   double[][] data;
   double[][] coordinates;
   final int dimcount=2;
   final double maxcoord=100;

//   double[] perspective;  //columns
//   String[] parameters;
//   int[] paramgroups;
   OntoParam[] params;  

   String[] names;    //rows
   boolean[] locked;
   Vector[] comments;
      
//   String[] paramgroupnames;
//   double[] paramgroupcoefs;
//   int[] parentgroupids;
   //Vector paramgroupv=new Vector();
   OntoParamGroup rootgroup=new OntoParamGroup("\\", 1, null);
   
   public static void main(String[] arg){
       OntoData m=new OntoData();
//       m.readDataFromFile("Creatures2.txt");
       m.readDataFromFile("aj.txt");
       m.normalizeData();
      // m.perspective=new double[]{0, 0, 1, 0,0, 0, 0, 0};
       m.randomCoordinates();
      // m.position(0);
       m.writeDataToFile("test1.txt");
       m.writeCoordinatesToFile("con");
   }
   
   String getDataAsText(){
      StringBuffer sb=new StringBuffer();
          for(int i=0; i<params.length; i++){
             sb.append("\t"+params[i].name);
          }
          sb.append("\n");
          for(int j=0; j<names.length; j++){
             sb.append(names[j]);
             for(int i=0; i<params.length; i++){
                double d=((int)(data[j][i]*1000))/1000.0;
//                sb.append("\t"+data[j][i]);
                sb.append("\t"+d);
             }
             sb.append("\n");
          }
      return sb.toString();      
   }

   void writeDataToFile(String filename){
      try{
          PrintWriter pw=new PrintWriter(new FileWriter(filename));
          String s=getDataAsText();
          pw.print(s);
          pw.close();
      }catch(Exception ex){
         ex.printStackTrace();
      }
   }

   
   void writeCoordinatesToFile(String filename){
      try{
          PrintWriter pw=new PrintWriter(new FileWriter(filename));
          for(int i=0; i<dimcount; i++){
             pw.print("\tc"+i);
          }
          pw.println();
          for(int j=0; j<names.length; j++){
             pw.print(names[j]);
             for(int i=0; i<dimcount; i++){
                //double d=((int)(coordinates[j][i]*1000))/1000.0;
                pw.print("\t"+coordinates[j][i]);
             }
             pw.println();
          }
          pw.close();
      }catch(Exception ex){
         ex.printStackTrace();
      }   
   }
   
   void readDataFromText(String text){
     double[][] olddata=data;
     String[]  oldnames=names;
//     String[]  oldparameters=parameters;
//     double[]  oldperspective=perspective;
     boolean[] oldlocked=locked;
     OntoParam[] oldparams=params;
     try{
       StringTokenizer stk=new StringTokenizer(text, "\n");
       Vector rows=new Vector();
       Vector vnames=new Vector();
       Vector vparameters=new Vector();
       while(stk.hasMoreTokens()){
          String s=stk.nextToken();
          if(s.trim().length()>0){
           try{
             String separator=" ";
             if(s.indexOf(",")>=0){separator=",";}
             if(s.indexOf(";")>=0){separator=";";}
             if(s.indexOf("\t")>=0){separator="\t";}
             Vector row=new Vector();
             StringTokenizer stk2=new StringTokenizer(s, separator);
             while(stk2.hasMoreTokens()){
                String s2=stk2.nextToken();
                row.add(s2);
             }
             if(row.size()>0){
               rows.add(row);
             }
           }catch(Exception rex){
             System.out.println("Problem with row data "+rex.getMessage());
             System.out.println(s);
           }
          }           
       }
       if(rows.size()==0){
          params=new OntoParam[0];
          names=new String[0];
          data=new double[0][0];
          return;
       }
       rootgroup=new OntoParamGroup("\\", 1, null);
       Vector v0=(Vector)rows.get(0);
       if(v0.size()<1){throw new RuntimeException("invalid data");}
       boolean parametersExists=false;
       try{
         Double.parseDouble((String)v0.get(1));
       }catch(Exception ex){
         parametersExists=true;
       }
       if(parametersExists){
          params=new OntoParam[v0.size()];
          for(int i=0; i<v0.size(); i++){
             params[i]=new OntoParam();
             params[i].name=(String)v0.get(i);
          }
          rows.removeElementAt(0);
       }
       if(rows.size()==0){
          params=new OntoParam[0];
          names=new String[0];
          data=new double[0][0];
          return;
       }
       
       data=new double[rows.size()][((Vector)rows.get(0)).size()-1];
       names=new String[rows.size()];
       locked=new boolean[rows.size()];
       if(!parametersExists){
          params=new OntoParam[((Vector)rows.get(0)).size()-1];
          for(int i=0; i<params.length; i++){
             params[i]=new OntoParam();
             params[i].name="xx"+i;
          }
       }
       for(int j=0; j<rows.size(); j++){
          Vector v=(Vector)rows.get(j);
          if(v.size()!=params.length+1){
             System.out.println(v+ " " + v.size());
             throw new RuntimeException("Incorrect row size "+j);
          }
          names[j]=(String)v.get(0);
          for(int i=1; i<v.size(); i++){
             data[j][i-1]=Double.parseDouble((String)v.get(i));
          }
       }
//       perspective=new double[data[0].length];
//       Arrays.fill(perspective, 1);

       if(params.length!=data[0].length){
         throw new RuntimeException("Incorrect column count");
       }

       if(names.length!=data.length){
         throw new RuntimeException("Incorrect row count");
       }
       randomCoordinates();
//        paramgroups=new int[data[0].length];
        comments=new Vector[data.length];
        for(int i=0; i<comments.length; i++){
           comments[i]=new Vector();
        }
//        paramgroupnames=new String[]{"ungrouped"};
//        paramgroupcoefs=new double[]{1.0};
//        parentgroupids=new int[]{0};
//        paramgrouplinks=new OntoParamGroup[data[0].length];
//        params=new OntoParam[data[0].length];
        for(int i=0; i<data[0].length; i++){
//           params[i]=new OntoParam(parameters[i], perspective[i], rootgroup);
           params[i].parent=rootgroup;
           rootgroup.addParameter(params[i]);
        }

     }catch(RuntimeException ex){
        data=olddata;
//        perspective=oldperspective;
        names=oldnames;
//        parameters=oldparameters;
        params=oldparams;
        locked=oldlocked;
        throw ex;
     }
   }

   void readSampleData(){
      String s=
        "	length	weight\n"+
        "metalsphere	0.05	1\n"+
        "cherry	0.05	0.01\n"+
        "paper	0.5	0.01\n"+
        "book	0.5	1\n";
      readDataFromText(s);  
   }



   void readDataFromFile(String filename){
      try{
         BufferedReader br=new BufferedReader(new FileReader(filename));
         String s=br.readLine();
         StringBuffer buf=new StringBuffer();
         while(s!=null){
            buf.append("\n"+s);
            s=br.readLine();
         }
         br.close();
         readDataFromText(buf.toString());
         rootgroup.name=filename;
      } catch(Exception ex){
         ex.printStackTrace();
      }
   }
   
   void insertRow(){
       insertRow(data.length);
   }
   
   void insertRow(int rownr){
       insertRow(rownr, new OntoRowData(data[0].length, dimcount));
   }
   
   void insertRow(int rownr, OntoRowData newdata){
       insertDataRow(rownr);
       copyDataRow(rownr, newdata); 
   }

   void insertDataRow(int rownr){
      addOrRemoveDataRow(rownr, true);
   }
   
   void copyDataRow(int rownr, OntoRowData newdata){
      if(data[0].length!=newdata.rdata.length){
         throw new RuntimeException("Column count does not match");
      }
      names[rownr]=newdata.rname;
      for(int i=0; i<data[0].length; i++){
         data[rownr][i]=newdata.rdata[i];
      }
      for(int i=0; i<dimcount; i++){
         coordinates[rownr][i]=newdata.rcoordinates[i];
      }
      locked[rownr]=newdata.rlocked;
      comments[rownr]=new Vector(newdata.rcomment);
   }

   OntoRowData removeRow(int rownr){
      OntoRowData bak=copyRow(rownr);
      deleteDataRow(rownr);
      return bak;
   }
   OntoRowData copyRow(int rownr){
      OntoRowData bak=new OntoRowData(names[rownr], data[rownr], coordinates[rownr], locked[rownr], comments[rownr]);
      return bak;
   }
   void deleteDataRow(int rownr){
      addOrRemoveDataRow(rownr, false);
   }
   void addOrRemoveDataRow(int rownr, boolean add){
      int newlen=data.length+1;
      if(!add){newlen=data.length-1;}
      String[] newnames=new String[newlen];
      double[][] newdata=new double[newlen][data[0].length];
      double[][] newcoordinates=new double[newlen][dimcount];
      boolean[] newlocked=new boolean[newlen];
      Vector[] newcomments=new Vector[newlen];
      for(int j=0; j<Math.min(newlen, data.length); j++){
          int newrow=j, oldrow=j;   
          if(add){
             if(j>=rownr){newrow=j+1;}
          } else {
             if(j>=rownr){oldrow=j+1;}
          }
          newnames[newrow]=names[oldrow];
          for(int i=0; i<data[0].length; i++){
             newdata[newrow][i]=data[oldrow][i];
          }
          for(int i=0; i<dimcount; i++){
             newcoordinates[newrow][i]=coordinates[oldrow][i];
          }
          newcomments[newrow]=comments[oldrow];
      }
      names=newnames;
      data=newdata;
      coordinates=newcoordinates;
      locked=newlocked;
      comments=newcomments;
   }



   void insertColumn(){
       insertColumn(data[0].length);
   }
   
   void insertColumn(int colnr){
       insertColumn(colnr, new OntoColumnData(data.length));
   }
   
   void insertColumn(int colnr, OntoColumnData newdata){
       insertDataColumn(colnr);
       copyDataColumn(colnr, newdata); 
   }

   void insertDataColumn(int colnr){
      addOrRemoveDataColumn(colnr, true);
   }
   
   void copyDataColumn(int colnr, OntoColumnData newdata){
      if(data.length!=newdata.cdata.length){
         throw new RuntimeException("Row count does not match");
      }
/*
      parameters[colnr]=newdata.cname;
      perspective[colnr]=newdata.perspective;
      paramgroups[colnr]=newdata.cparamgroup;
*/
//      System.out.println(colnr+" "+params[colnr]+" "+newdata);
      params[colnr]=new OntoParam(newdata.cname, newdata.perspective, newdata.cparamgroup);
      params[colnr].parent.parameters.add(params[colnr]);
//      params[colnr].name=newdata.cname;
//      params[colnr].coef=newdata.perspective;
//      params[colnr].parent=newdata.cparamgroup;
      for(int i=0; i<data.length; i++){
         data[i][colnr]=newdata.cdata[i];
      }
   }

   OntoColumnData removeColumn(int colnr){
      OntoColumnData bak=copyColumn(colnr);
      deleteDataColumn(colnr);
      return bak;
   }
   
   void duplicateColumn(int colnr){
      OntoColumnData temp=copyColumn(colnr);
      insertColumn(colnr, temp);
   }
   
   OntoColumnData copyColumn(int colnr){
      double[] tdata=new double[data.length];
      for(int i=0; i<data.length; i++){
         tdata[i]=data[i][colnr];
      }
      OntoColumnData bak=new OntoColumnData(params[colnr].name, params[colnr].coef, params[colnr].parent, tdata);
      return bak;
   }
   void deleteDataColumn(int colnr){
      addOrRemoveDataColumn(colnr, false);
   }
   void addOrRemoveDataColumn(int colnr, boolean add){
      int newlen=data[0].length+1;
      if(!add){newlen=data[0].length-1;
         params[colnr].parent.parameters.remove(params[colnr]);
      }
      /*
      String[] newparameters=new String[newlen];
      double[] newperspective=new double[newlen];
      int[] newparamgroups=new int[newlen];
      */
      OntoParam[] newparams=new OntoParam[newlen];
      double[][] newdata=new double[data.length][newlen];
      for(int j=0; j<Math.min(newlen, data[0].length); j++){
          int newcol=j, oldcol=j;   
          if(add){
             if(j>=colnr){newcol=j+1;}
          } else {
             if(j>=colnr){oldcol=j+1;}
          }
/*
          newparameters[newcol]=parameters[oldcol];
          newperspective[newcol]=perspective[oldcol];
          newparamgroups[newcol]=paramgroups[oldcol];
*/
          newparams[newcol]=params[oldcol];
          for(int i=0; i<data.length; i++){
             newdata[i][newcol]=data[i][oldcol];
          }
      }
//      parameters=newparameters;
//      perspective=newperspective;
//      paramgroups=newparamgroups;
      params=newparams;
      data=newdata;
   }

/*
   void setParamGroup(int parameter, int groupnr){
      if(groupnr>=paramgroupnames.length){
         throw new RuntimeException("Too big group number");
      }
      paramgroups[parameter]=groupnr;
   }
*/

/*
   int addParamGroup(String groupname){
      String[] newgroupnames=new String[paramgroupnames.length+1];
      double[] newgroupcoefs=new double[paramgroupcoefs.length+1];
      int[] newparentgroupids=new int[paramgroupcoefs.length+1];
      for(int i=0; i<paramgroupnames.length; i++){
         newgroupnames[i]=paramgroupnames[i];
         newgroupcoefs[i]=paramgroupcoefs[i];
         newparentgroupids[i]=parentgroupids[i];
      }
      newgroupnames[paramgroupnames.length]=groupname;
      newgroupcoefs[paramgroupcoefs.length]=1.0;
      newparentgroupids[paramgroupcoefs.length]=0;
      paramgroupnames=newgroupnames;
      paramgroupcoefs=newgroupcoefs;
      parentgroupids=newparentgroupids;
      return paramgroupnames.length;
   }
*/
/*   
   int removeLastEmptyGroup(){
      int lastnr=paramgroupnames.length-1;
      int count=0; 
      for(int i=0; i<paramgroups.length; i++){
         if(paramgroups[i]==lastnr){
            count++;
         }
      }
      if(count>0){
        throw new RuntimeException("Last group has "+count+" parameters");
      }
      String[] newgroupnames=new String[paramgroupnames.length-1];
      double[] newgroupcoefs=new double[paramgroupnames.length-1];
      for(int i=0; i<newgroupnames.length; i++){
         newgroupnames[i]=paramgroupnames[i];
         newgroupcoefs[i]=paramgroupcoefs[i];
      }
      paramgroupnames=newgroupnames;
      paramgroupcoefs=newgroupcoefs;
      return paramgroupnames.length;      
   }
 */
/*
   void normalizeData(){
      for(int i=0; i<data[0].length; i++){
         double max=0;
         for(int j=0; j<data.length; j++){
            if(data[j][i]>max){max=data[j][i];}
         }
         if(max>1){
            for(int j=0; j<data.length; j++){
               data[j][i]=data[j][i]/max;
            }
         }
      }
   }
*/   
   void normalizeData(){
      if(data.length==0){return;}
      for(int i=0; i<data[0].length; i++){
         double max=0;
         double min=0;
         for(int j=0; j<data.length; j++){
            if(j==0){min=max=data[j][i];}
            if(data[j][i]>max){max=data[j][i];}
            if(data[j][i]<min){min=data[j][i];}
         }
         for(int j=0; j<data.length; j++){
               data[j][i]=(data[j][i]-min)/(max-min);
         }
      }
   }


   void normalizeCoordinates(){
      for(int i=0; i<coordinates[0].length; i++){
         double min=coordinates[0][i];
         double max=min;
         for(int j=0; j<coordinates.length; j++){
            if(coordinates[j][i]<min){min=coordinates[j][i];}
            if(coordinates[j][i]>max){max=coordinates[j][i];
            }
         }
         double koef=2*maxcoord/(max-min);
         double centre=(max+min)/2;
         for(int j=0; j<coordinates.length; j++){
            coordinates[j][i]=(coordinates[j][i]-centre)*koef;
         }
      }
   }
   
   void randomCoordinates(){
      coordinates=new double[data.length][dimcount];
      for(int i=0; i<dimcount; i++){
         for(int j=0; j<data.length; j++){
            coordinates[j][i]=(Math.random()-0.5)*2*maxcoord;
         }
      }
   }
   
   int terate(){
       int a=(int)(data.length*Math.random());
       if(!locked[a]){
          position(a);
       }
       return a;
   }
   
   void position(int a){
      double scaler=100;
      double step=0.001;
      int m=data.length;
      if(m<2){return;}
      for(int b=0; b<m; b++){
         double targetdistance=scaler*(ontodistance(a, b));
        // System.out.println("targetd "+targetdistance);
         double delta=ddistance(a, b)-targetdistance;
         //if(delta<-100){delta=-100;}
         //if(delta>100){delta=100;}
         double[] newloc=approach(a, b, delta*step);
         for(int i=0; i<newloc.length; i++){
            coordinates[a][i]=newloc[i];
          //  System.out.println(coordinates[a][i]);
         }         
      }
//      normalizeCoordinates();
   }
   
   double[] approach(int a, int b, double step){
      double[] aloc=coordinates[a];
      double[] bloc=coordinates[b];
      int dimensions=aloc.length;
      double[] newloc=new double[dimensions];
      for(int d=0; d<dimensions; d++){
         double ad=aloc[d];
         double bd=bloc[d];
         double ddist=ad-bd;
         double newd=ad-ddist*step;
         newloc[d]=newd;
      }
      return newloc;
   }
   
   double ontodistance(int a, int b){
      double[] aloc=ontovector(a);
      double[] bloc=ontovector(b);
      int dimensions=aloc.length;
      double dcum=0;
      for(int d=0; d<dimensions; d++){
         double ad=aloc[d];
         double bd=bloc[d];
         dcum+=Math.pow(ad-bd, 2);
      }
      return Math.sqrt(dcum);
   }
   
   double[] ontovector(int i){
      double[] ivector=new double[data[i].length];
      for(int w=0; w<ivector.length; w++){
//        ivector[w]=data[i][w]*perspective[w];
//        ivector[w]=data[i][w]*params[w].coef;
        ivector[w]=data[i][w]*params[w].getActualCoef();
      }
      return ivector;
   }
   
   double ddistance(int a, int b){
      double[] aloc=coordinates[a];
      double[] bloc=coordinates[b];
      int dimensions=aloc.length;
      double dcum=0;
      for(int d=0; d<dimensions; d++){
         double ad=aloc[d];
         double bd=bloc[d];
         dcum+=Math.pow(Math.abs(ad-bd), 2);
      }
      return Math.sqrt(dcum);
   }  
}