import javax.swing.*;
import javax.swing.event.*;
import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.net.*;
import java.util.*;

/**
* Toolboxes for manipulating data. File IO, zooming, edit/copy rows and columns, 
* slider groups, name groups with comments.
*/
public class OntoDataFrame extends JFrame implements 
        ActionListener, ListSelectionListener, ChangeListener, ItemListener{
   OntoApp oa;
   JTextArea ta=new JTextArea();
   JButton b1=new JButton("Use data");
   JButton bRead=new JButton("Read from file");
   JButton bWrite=new JButton("Write to file");
//   JButton bclose=new JButton("Close frame");
   JTabbedPane jtp=new JTabbedPane();
   JButton bzoomplus=new JButton("Zoom+");
   JButton bzoomminus=new JButton("Zoom-");
   JButton bzoomview=new JButton("Zoom to view");
   JButton bznormalize=new JButton("Normalize coordinates");
   JCheckBox czoomview=new JCheckBox("Zoom to view while calculating", true);
   JButton bzl=new JButton("Left");
   JButton bzr=new JButton("Right");
   JButton bzu=new JButton("Up");
   JButton bzd=new JButton("Down");
   
   JCheckBox bzapptableview=new JCheckBox("View table", false);
   JCheckBox bzappslidersview=new JCheckBox("View sliders", true);
   JComboBox bzdrawtype=new JComboBox(new Object[]{"Words only", "Balls"});
   
   
   JButton brcut=new JButton("Cut");
   JButton brcopy=new JButton("Copy");
   JButton brpaste=new JButton("Paste");
   JButton brinsert=new JButton("Insert");
   JButton brdelete=new JButton("Delete");
   
   OntoRowData rowclipboard;

   JButton brccut=new JButton("Cut");
   JButton brccopy=new JButton("Copy");
   JButton brcpaste=new JButton("Paste");
   JButton brcinsert=new JButton("Insert");
   JButton brcdelete=new JButton("Delete");
   JTextField brparameter=new JTextField("");
   OntoColumnData columnclipboard;
   
   JList brlist=new JList();
   JButton brnormalize=new JButton("Normalize data");
   JButton brlockall=new JButton("Lock all");
   JButton brunlockall=new JButton("Unlock all");
   JButton brlockbiggest=new JButton("Lock biggest");
   JCheckBox brautomcalc=new JCheckBox("Automatic calculating", true);
   
   JList[] sgparameters;
   JSlider[] sgsliders;
   JButton[] sgadd;
   JButton[] sgremove;
   JTextField[] sggroupname;
   JButton sgnewgroup=new JButton("New group");
   JButton sgremovelast=new JButton("Remove last");
   JPanel sgpanel; //slider group panel
   
   JList gwordlist;
   JTextArea gcommentarea=new JTextArea();
   JList gcommentlist=new JList();
   JButton gdelcomm=new JButton("Delete comment");
   JTextField gcommentfield=new JTextField();
   JComboBox gnewcalctype=new JComboBox(new String[]{"Average", "Sum"});
   JTextField gnewname=new JTextField();
   
   JPanel p1=new JPanel(new BorderLayout());
   JPanel p2=new JPanel(new BorderLayout());
   JPanel p3=new JPanel(new BorderLayout());
   JPanel p4=new JPanel(new BorderLayout());
   JPanel p5=new JPanel(new BorderLayout());
   
   public OntoDataFrame(OntoApp oa){
      this.oa=oa;
      jtp.add("csv",    p1);
      jtp.add("zoom",   p2);
      jtp.add("data",   p3);
     // jtp.add("slider", p4);
      jtp.add("group",  p5);
      getContentPane().add(jtp, BorderLayout.CENTER);
      p1.add(new JScrollPane(ta), BorderLayout.CENTER);
      JPanel buttonPanel=new JPanel(new GridLayout());
      buttonPanel.add(b1);
      if(oa.isStandalone){
         buttonPanel.add(bRead);
         buttonPanel.add(bWrite);
      }
//      buttonPanel.add(bclose);
      p1.add(buttonPanel, BorderLayout.NORTH);
      b1.addActionListener(this);
      bRead.addActionListener(this);
      bWrite.addActionListener(this);
//      bclose.addActionListener(this);
      JPanel p2south=new JPanel(new GridLayout(2, 1));
      JPanel bzpanel=new JPanel(new GridLayout(1, 4));
      bzpanel.add(bzl);
      bzpanel.add(bzr);
      bzpanel.add(bzu);
      bzpanel.add(bzd);
      bzl.addActionListener(this);
      bzr.addActionListener(this);
      bzu.addActionListener(this);
      bzd.addActionListener(this);
      p2south.add(bzpanel);
      JPanel bzpanel2=new JPanel(new GridLayout(1, 4));
      bzpanel2.add(bzoomplus);
      bzpanel2.add(bzoomminus);
      bzpanel2.add(bzoomview);
      bzpanel2.add(bznormalize);
      bzoomplus.addActionListener(this);
      bzoomminus.addActionListener(this);
      bzoomview.addActionListener(this);
      bznormalize.addActionListener(this);
      p2south.add(bzpanel);
      p2south.add(bzpanel2);
      p2.add(p2south, BorderLayout.SOUTH);
      p2.add(czoomview, BorderLayout.NORTH);
      czoomview.addActionListener(this);
      JPanel p2east=new JPanel(new BorderLayout());
      JPanel p2east2=new JPanel(new GridLayout(3, 1));
      p2east2.add(bzapptableview);
      p2east2.add(bzappslidersview);
      p2east2.add(bzdrawtype);
      bzdrawtype.setToolTipText("Drawing type");
      bzdrawtype.addItemListener(this);
      bzapptableview.addChangeListener(this);
      bzappslidersview.addChangeListener(this);
      p2east.add(p2east2, BorderLayout.NORTH);
      p2.add(p2east, BorderLayout.EAST);
      JPanel brpanel=new JPanel(new GridLayout(1, 6));
      JLabel brrowlabel=new JLabel("Rows:");
      brrowlabel.setToolTipText("Use table rows");
      brpanel.add(brrowlabel);
      brpanel.add(brcut);
      brpanel.add(brcopy);
      brpanel.add(brpaste);
      brpanel.add(brinsert);
      brpanel.add(brdelete);
      
      brcut.addActionListener(this);
      brcopy.addActionListener(this);
      brpaste.addActionListener(this);
      brinsert.addActionListener(this);
      brdelete.addActionListener(this);
      p3.add(brpanel, BorderLayout.SOUTH);
      JPanel p3west=new JPanel(new BorderLayout());
      p3west.add(new JScrollPane(brlist), BorderLayout.WEST);
      brlist.addListSelectionListener(this);
      p3west.add(brparameter, BorderLayout.SOUTH);
      brparameter.addActionListener(this);
      p3.add(p3west, BorderLayout.WEST);
      brlist.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);

      JPanel brcpanel=new JPanel(new GridLayout(1, 6));
      brcpanel.add(new JLabel("Columns:"));
      brcpanel.add(brccut);
      brcpanel.add(brccopy);
      brcpanel.add(brcpaste);
      brcpanel.add(brcinsert);
      brcpanel.add(brcdelete);
      
      brccut.addActionListener(this);
      brccopy.addActionListener(this);
      brcpaste.addActionListener(this);
      brcinsert.addActionListener(this);
      brcdelete.addActionListener(this);
      p3.add(brcpanel, BorderLayout.NORTH);
      JPanel p3east=new JPanel(new GridLayout(9, 1));
      p3east.add(brnormalize);
      p3east.add(brlockall);
      p3east.add(brunlockall);
      p3east.add(brlockbiggest);
      p3east.add(oa.b1);
      p3east.add(oa.btf1);
      p3east.add(oa.b2);
      p3east.add(oa.b3);
      p3east.add(brautomcalc);
      brautomcalc.setToolTipText("Calculate after each change");
      p3.add(p3east, BorderLayout.EAST);
      brnormalize.addActionListener(this);
      brlockall.addActionListener(this);
      brunlockall.addActionListener(this);
      brlockbiggest.addActionListener(this);
      sgnewgroup.addActionListener(this);
      sgremovelast.addActionListener(this);
      
      gwordlist=new JList();
      JPanel p5west=new JPanel(new BorderLayout());
      p5west.add(gdelcomm, BorderLayout.SOUTH);
      p5west.add(new JScrollPane(gwordlist), BorderLayout.CENTER);
      p5.add(p5west, BorderLayout.WEST);
      gdelcomm.addActionListener(this);
//      p5.add(new JScrollPane(gcommentarea), BorderLayout.CENTER);
      p5.add(new JScrollPane(gcommentlist), BorderLayout.CENTER);
      JPanel p5south=new JPanel(new BorderLayout());
      p5south.add(new JLabel("Add comment:"), BorderLayout.WEST);
      p5south.add(gcommentfield, BorderLayout.CENTER);
      p5.add(p5south, BorderLayout.SOUTH);
      gcommentfield.addActionListener(this);
      gwordlist.addListSelectionListener(this);
      JPanel p5east=new JPanel(new GridLayout(5, 1));
      p5east.add(new JLabel("Calculating type"));
      p5east.add(gnewcalctype);
      p5east.add(new JLabel("Object name"));
      p5east.add(gnewname);
      p5east.add(new JLabel("Add object"));
      gnewname.addActionListener(this);
      JPanel p5east1=new JPanel(new BorderLayout());
      p5east1.add(p5east, BorderLayout.NORTH);
      p5.add(p5east1, BorderLayout.EAST);
      
      setSize(500, 300);
      setTitle("Data frame");
   }
   public void actionPerformed(ActionEvent e){
     try{
//      if(e.getSource()==bclose){
//         this.setVisible(false);
//      }
      if(e.getSource()==b1){
        try{
         oa.od.readDataFromText(ta.getText());
         oa.od.normalizeData();
         oa.os.initialize();
         oa.addTable();
         oa.addTree();
         oa.repaint();
        }catch(Exception ex2){
           JOptionPane.showMessageDialog(null, ex2.toString(), "Problem", JOptionPane.ERROR_MESSAGE);
        }
      }
      if(e.getSource()==bRead){
          JFileChooser jfc=new JFileChooser(new File("."));
          if(jfc.showSaveDialog(this)==JFileChooser.APPROVE_OPTION){
              File f=jfc.getSelectedFile();
              BufferedReader br=new BufferedReader(new FileReader(f));
              String s=br.readLine();
              StringBuffer sb=new StringBuffer();
              while(s!=null){
                 sb.append(s+"\n");
                 s=br.readLine();
              }
              br.close();
              ta.setText(sb.toString());
          }
      }
      if(e.getSource()==bWrite){
          JFileChooser jfc=new JFileChooser(new File("."));
          if(jfc.showOpenDialog(this)==JFileChooser.APPROVE_OPTION){
              File f=jfc.getSelectedFile();
              PrintWriter pw=new PrintWriter(new FileWriter(f));
              pw.print(ta.getText());
              pw.close();         
          }
      }
      double stepkoef=0.5;
      if(e.getSource()==bzl){
         oa.op.wcx-=stepkoef*oa.op.getWidth()/2/oa.op.koef;
      }
      if(e.getSource()==bzr){
         oa.op.wcx+=stepkoef*oa.op.getWidth()/2/oa.op.koef;
      }
      if(e.getSource()==bzu){
         oa.op.wcy+=stepkoef*oa.op.getHeight()/2/oa.op.koef;
      }
      if(e.getSource()==bzd){
         oa.op.wcy-=stepkoef*oa.op.getHeight()/2/oa.op.koef;
      }
      if(e.getSource()==bzoomplus){
         oa.op.koef*=1.5;
      }
      if(e.getSource()==bzoomminus){
         oa.op.koef/=1.5;
      }
      if(e.getSource()==bzoomview){
         oa.op.calculateKoef();
      }
      if(e.getSource()==bznormalize){
         oa.od.normalizeCoordinates();
         oa.op.calculateKoef();
      }
      if(e.getSource()==czoomview){
         oa.op.zoomToBoundsWhileCalculating=czoomview.isSelected();
      }
      int trow=oa.table.getSelectedRow();
      boolean rowchanged=false;
      if(e.getSource()==brcut){
         if(trow>-1 && trow<oa.od.data.length){
            rowclipboard=oa.od.removeRow(trow);
            rowchanged=true;
         }
      }
      if(e.getSource()==brcopy){
         if(trow>-1 && trow<oa.od.data.length){
            rowclipboard=oa.od.copyRow(trow);
         }
      
      }
      if(e.getSource()==brpaste){
         if(trow==-1){trow=oa.od.data.length;}         
         if(rowclipboard!=null){
           oa.od.insertRow(trow, rowclipboard);
           rowchanged=true;
         }
      }
      if(e.getSource()==brinsert){
         if(trow==-1){trow=oa.od.data.length;}
         oa.od.insertRow(trow);
         rowchanged=true;
      }
      if(e.getSource()==brdelete){
         if(trow>-1 && trow<oa.od.data.length){
            oa.od.removeRow(trow);
            rowchanged=true;
         }
      }

      if(rowchanged){
         readGroupWordListData();
      }

      int tcol=brlist.getSelectedIndex();
      boolean colChanged=false;
      if(e.getSource()==brccut){
         if(tcol>-1 && tcol<oa.od.data[0].length){
            columnclipboard=oa.od.removeColumn(tcol);
            colChanged=true;
         }
      }
      if(e.getSource()==brccopy){
         if(tcol>-1 && trow<oa.od.data[0].length){
            columnclipboard=oa.od.copyColumn(tcol);
         }      
      }
      if(e.getSource()==brcpaste){
         if(tcol==-1){tcol=oa.od.data[0].length;}         
         if(columnclipboard!=null){
           oa.od.insertColumn(tcol, columnclipboard);
           colChanged=true;
         }
      }
      if(e.getSource()==brcinsert){
         if(tcol==-1){tcol=oa.od.data[0].length;}
         oa.od.insertColumn(tcol);
         colChanged=true;
      }
      if(e.getSource()==brcdelete){
         if(tcol>-1 && tcol<oa.od.data[0].length){
            oa.od.removeColumn(tcol);
            colChanged=true;
         }
      }
      
      if(e.getSource()==brparameter){
        if(brlist.getSelectedIndex()>-1){
         oa.od.params[brlist.getSelectedIndex()].name=brparameter.getText();
         colChanged=true;
        }
      }

      if(colChanged){
         oa.addTable();
         oa.addTree();
         oa.os.initialize();
         rowclipboard=null;
         String[] ps=new String[oa.od.params.length];
         for(int k=0; k<ps.length; k++){
            ps[k]=oa.od.params[k].name;
         }
         brlist.setListData(ps);
         makeSliderGroupPanel();
      }
      
      if(e.getSource()==brnormalize){
        oa.od.normalizeData();
      }
      
      if(e.getSource()==brlockall){
         for(int j=0; j<oa.od.data.length; j++){
            oa.od.locked[j]=true;
         }
      }
      if(e.getSource()==brunlockall){
         for(int j=0; j<oa.od.data.length; j++){
            oa.od.locked[j]=false;
         }
      }
      if(e.getSource()==brlockbiggest){
         for(int j=0; j<oa.od.data.length; j++){
            oa.od.locked[j]=false;
         }
         int maxid=0;
         double maxdata=0;
         for(int j=0; j<oa.od.data.length; j++){
            double sum=0;
            for(int i=0; i<oa.od.data[0].length; i++){
               sum+=oa.od.data[j][i];
            }
            if(sum>maxdata){
               maxdata=sum;
               maxid=j;
            }
         }      
         oa.od.locked[maxid]=true;
      }
  /*    
      for(int i=0; i<oa.od.paramgroupnames.length; i++){
         if(e.getSource()==sggroupname[i]){
            oa.od.paramgroupnames[i]=sggroupname[i].getText();
         }
         if(e.getSource()==sgadd[i]){
            Object[] opr=sgparameters[0].getSelectedValues();
            if(opr!=null){
              for(int j=0; j<opr.length; j++){
                oa.od.paramgroups[((OntoPair)opr[j]).getID()]=i;
              }
              makeSliderGroupPanel();
            }
         }
         if(e.getSource()==sgremove[i]){
            Object[] opr=sgparameters[i].getSelectedValues();
            if(opr!=null){
              for(int j=0; j<opr.length; j++){
                oa.od.paramgroups[((OntoPair)opr[j]).getID()]=0;
              }
              makeSliderGroupPanel();
            }
         }
      }
*/
/*
      if(e.getSource()==sgnewgroup){
        oa.od.addParamGroup("new group "+oa.od.paramgroupnames.length);
        makeSliderGroupPanel();
      }
      
      if(e.getSource()==sgremovelast){
        try{
            oa.od.removeLastEmptyGroup();
            makeSliderGroupPanel();
        } catch(Exception ex2){
           JOptionPane.showMessageDialog(null, "Removing problem", ex2.getMessage(), JOptionPane.ERROR_MESSAGE);	
        }
      }
*/      
      if(e.getSource()==gcommentfield){
          int[] selected=gwordlist.getSelectedIndices();
          for(int j=0; j<selected.length; j++){
             Vector v=oa.od.comments[selected[j]];
             String s=gcommentfield.getText();
             if(!v.contains(s)){
                v.add(s);
             }
          }
          gcommentfield.setText("");
//          updateGCommentArea();
          updateGCommentList();
      }
      
      if(e.getSource()==gnewname){
        if(gnewname.getText().trim().length()>0){
         addNewGroupRow();
        }
      }

      if(e.getSource()==gdelcomm){
         int selected[]=gwordlist.getSelectedIndices();
         Object selcomm[]=gcommentlist.getSelectedValues();
         for(int j=0; j<selected.length; j++){
            for(int i=0; i<selcomm.length; i++){
               oa.od.comments[selected[j]].remove(((OntoPair)selcomm[i]).getSID());
            }
         }
         updateGCommentList();
      }

      //oa.validate();
      oa.table.revalidate();
      //oa.tablePanel.revalidate();
      oa.repaint();
     }catch(Exception ex){
        ex.printStackTrace();
     }
   }

   public void stateChanged(ChangeEvent e){
    /*
      for(int i=0; i<oa.od.paramgroupnames.length; i++){
         if(e.getSource()==sgsliders[i]){
            for(int j=0; j<oa.od.paramgroups.length; j++){
               if(oa.od.paramgroups[j]==i){                 
                  oa.os.sliders[j].setValue(sgsliders[i].getValue());
                  oa.os.stfs[j].setText(String.valueOf(sgsliders[i].getValue()/100.0));
               }
            }
         }   
      }
    */
      if(e.getSource()==bzapptableview || e.getSource()==bzappslidersview){
         oa.reloadLayout();
      }
   }
   
   public void valueChanged(ListSelectionEvent e){
      if(e.getSource()==brlist){
        if(brlist.getSelectedIndex()>-1){
         brparameter.setText(oa.od.params[brlist.getSelectedIndex()].name);
        }
      }
      if(e.getSource()==gwordlist){
//         updateGCommentArea();     
         updateGCommentList();     
      }
   }
   
   public void itemStateChanged(ItemEvent e){
      if(e.getSource()==bzdrawtype){
        oa.repaint();
      }   
   }
   
   /**
   *  Returs array in each vector of parameter names ordered by group numbers.
   */
   /*
   public Vector[] readParamGroups(){
      Vector[] groups=new Vector[oa.od.paramgroupnames.length];
      for(int j=0; j<groups.length; j++){groups[j]=new Vector();}
      for(int i=0; i<oa.od.data[0].length; i++){
         groups[oa.od.paramgroups[i]].addElement(new OntoPair(oa.od.parameters[i], i));
      }
      return groups;
   }
   */
   /**
   * Make layout for slider group toolbox.
   */
   void makeSliderGroupPanel(){
      if(sgpanel!=null){
        p4.remove(sgpanel);
      }
/*
      Vector[] paramvec=readParamGroups();
      int count=oa.od.paramgroupnames.length;
      sgpanel=new JPanel(new GridLayout(1, count+1));
      sgparameters=new JList[count];
      sgsliders=new JSlider[count];
      sgadd=new JButton[count];
      sgremove=new JButton[count];
      sggroupname=new JTextField[count];
      for(int i=0; i<count; i++){
         JPanel spanel=new JPanel(new BorderLayout());
         JPanel sbpanel=new JPanel(new GridLayout(4, 1));
         sgparameters[i]=new JList(paramvec[i]);
         sgsliders[i]=new JSlider(0, 100, 100);
         sgsliders[i].addChangeListener(this);
         sgadd[i]=new JButton("add");
         sgadd[i].addActionListener(this);
         sgremove[i]=new JButton("remove");
         sgremove[i].addActionListener(this);
         sggroupname[i]=new JTextField(oa.od.paramgroupnames[i]);
         sggroupname[i].addActionListener(this);
         if(i==0){
            sgadd[i].setEnabled(false);
            sgadd[i].setText(" ");
            sgremove[i].setEnabled(false);
            sgremove[i].setText(" ");
         }  
         sbpanel.add(sgadd[i]);
         sbpanel.add(sgremove[i]);
         sbpanel.add(sggroupname[i]);
         sbpanel.add(sgsliders[i]);         
         spanel.add(new JScrollPane(sgparameters[i]), BorderLayout.CENTER);
         spanel.add(sbpanel, BorderLayout.SOUTH);
         sgpanel.add(spanel);
      }
      JPanel sgnpanel=new JPanel(new BorderLayout());
      sgnpanel.add(sgnewgroup, BorderLayout.SOUTH);
      if(paramvec[paramvec.length-1].size()==0){
        sgnpanel.add(sgremovelast, BorderLayout.NORTH);
      }
      sgpanel.add(sgnpanel);
      p4.add(sgpanel, BorderLayout.CENTER);
      p4.revalidate();
  */
   }
   
   /**
   *  Holds word names up to date in word group toolbox.
   */
   void readGroupWordListData(){
      gwordlist.setListData(oa.od.names);
   }
   
   /**
   *  Shows word comments in 5th toolbox.
   */
   
   void updateGCommentArea(){
      StringBuffer sb=new StringBuffer();
      int[] selected=gwordlist.getSelectedIndices();
      HashMap hm=new HashMap();
      for(int j=0; j<selected.length; j++){
         Vector v=oa.od.comments[selected[j]];
         for(int i=0; i<v.size(); i++){
          /*
           if(!hm.containsKey(v.get(i))){
             hm.put(v.get(i), new Integer(1));
           } else {
             int nr=((Integer)hm.get(v.get(i))).intValue()+1;
             hm.put(v.get(i), new Integer(nr));
           }
           */
           if(!hm.containsKey(v.get(i))){
             hm.put(v.get(i), new Vector());
           } 
           Vector v2=(Vector)hm.get(v.get(i));
           v2.add(oa.od.names[selected[j]]);
           hm.put(v.get(i), v2);
         }
      }  
      Iterator it=hm.keySet().iterator();
      while(it.hasNext()){
         String s=(String)it.next();
//         int nr=((Integer)hm.get(s)).intValue();
         Vector v=(Vector)hm.get(s);
//         sb.append(nr+" "+s+"\n");
         sb.append(s+" "+v.toString()+"\n");
      }
      gcommentarea.setText(sb.toString());
   }
   

   void updateGCommentList(){
      StringBuffer sb=new StringBuffer();
      int[] selected=gwordlist.getSelectedIndices();
      HashMap hm=new HashMap();
      for(int j=0; j<selected.length; j++){
         Vector v=oa.od.comments[selected[j]];
         for(int i=0; i<v.size(); i++){
          /*
           if(!hm.containsKey(v.get(i))){
             hm.put(v.get(i), new Integer(1));
           } else {
             int nr=((Integer)hm.get(v.get(i))).intValue()+1;
             hm.put(v.get(i), new Integer(nr));
           }
           */
           if(!hm.containsKey(v.get(i))){
             hm.put(v.get(i), new Vector());
           } 
           Vector v2=(Vector)hm.get(v.get(i));
           v2.add(oa.od.names[selected[j]]);
           hm.put(v.get(i), v2);
         }
      }  
      OntoPair[] objs=new OntoPair[hm.size()];
      int nr=0;
      Iterator it=hm.keySet().iterator();
      while(it.hasNext()){
         String s=(String)it.next();
//         int nr=((Integer)hm.get(s)).intValue();
         Vector v=(Vector)hm.get(s);
//         sb.append(nr+" "+s+"\n");
//         sb.append(s+" "+v.toString()+"\n");
           objs[nr++]=new OntoPair(s+" "+v.toString(), s);
      }
      gcommentlist.setListData(objs);
//      gcommentarea.setText(sb.toString());
   }


   void addNewGroupRow(){
      int[] selected=gwordlist.getSelectedIndices();
      if(selected.length==0){
         oa.od.insertRow();
         oa.od.names[oa.od.names.length-1]=gnewname.getText();
      } else {
        OntoRowData[] old=new OntoRowData[selected.length];
        for(int i=0; i<selected.length; i++){
           old[i]=oa.od.copyRow(selected[i]);
        }
        int type=OntoRowData.CALCTYPE_AVERAGE;
        if(gnewcalctype.getSelectedIndex()==1){
           type=OntoRowData.CALCTYPE_SUM;
        }
        OntoRowData ord=new OntoRowData(gnewname.getText(), old, type);
        oa.od.insertRow(oa.od.data.length, ord);
      }
      gnewname.setText("");
   }
}