import java.awt.event.*;
import java.net.*;
import java.io.*;
import java.util.*;
import javax.swing.*;
import java.applet.*;
/**
* Listener for main application and drawing panel. 
* Place to find selected words.
*/
class OntoListener implements ActionListener, ItemListener, Runnable, MouseListener, MouseMotionListener{
  OntoApp oa;
  boolean continousCalculating=false;
  int selectedWord=-1;
  int mx=-1, my=-1;
  public void actionPerformed(ActionEvent e){
     if(e.getSource()==oa.b1){
       int n=Integer.parseInt(oa.btf1.getText());
       iterateN(n);
     }
     if(e.getSource()==oa.b2){
        oa.od.randomCoordinates();
        oa.op.calculateKoef();
        oa.repaint();
     }
     if(e.getSource()==oa.b3){
        if(!continousCalculating){
           new Thread(this).start();
        } else {
           continousCalculating=false;	
        }
     }
     if(e.getSource()==oa.b4){
        oa.odf.setVisible(true);
        oa.odf.ta.setText(oa.od.getDataAsText());
        String[] ps=new String[oa.od.params.length];
        for(int k=0; k<ps.length; k++){
           ps[k]=oa.od.params[k].name;
        }
        oa.odf.brlist.setListData(ps);
        oa.odf.brlist.revalidate();
        oa.odf.makeSliderGroupPanel();
        oa.odf.readGroupWordListData();
     }

  }
  
  void iterateN(int n){
       for(int i=0; i<n; i++){
        oa.od.terate();
       }
        if(oa.op.zoomToBoundsWhileCalculating){
           oa.op.calculateKoef();
        }
        oa.repaint();
  }
  
  public void run(){
     continousCalculating=true;
     oa.b3.setText("Stop calculating");
     while(continousCalculating){
        oa.od.terate();
        oa.repaint();
     }     
     oa.b3.setText("Continous calculating");
  }
  public String readFile(String filename) throws IOException{
     if(oa.isStandalone){
        BufferedReader br=new BufferedReader(new FileReader(filename));
        StringBuffer sb=new StringBuffer();
        String s=br.readLine();
        while(s!=null){
          sb.append(s+"\n");
          s=br.readLine();
        }
        br.close();
        return sb.toString();
     } else {
        BufferedReader br=new BufferedReader(new InputStreamReader(
          new URL(oa.getCodeBase(), filename).openStream()));
        StringBuffer sb=new StringBuffer();
        String s=br.readLine();
        while(s!=null){
          sb.append(s+"\n");
          s=br.readLine();
        }
        br.close();
        return sb.toString();
     }
  }
  void filenamesToChoice(){
    try{
     String s=readFile("ontofilelist.txt");
     StringTokenizer stk=new StringTokenizer(s, "\n");
     while(stk.hasMoreTokens()){
        oa.fileChoice.add(stk.nextToken());
     }
     readSelectedFileFromList();
    }catch(Exception ex){
        JOptionPane.showMessageDialog(null, ex.toString(), "Filename reading problem", JOptionPane.ERROR_MESSAGE);
    }
  }
  
  public void itemStateChanged(ItemEvent e){
     readSelectedFileFromList();  
  }
  
  void readSelectedFileFromList(){
     try{
         oa.od.readDataFromText(readFile(oa.fileChoice.getSelectedItem()));
         oa.od.rootgroup.name=oa.fileChoice.getSelectedItem();
         oa.od.normalizeData();
         oa.os.initialize();
         oa.od.randomCoordinates();
        String[] ps=new String[oa.od.params.length];
        for(int k=0; k<ps.length; k++){
           ps[k]=oa.od.params[k].name;
        }

         oa.odf.brlist.setListData(ps);
         oa.odf.ta.setText(oa.od.getDataAsText());
         oa.odf.brlist.revalidate();
         oa.odf.makeSliderGroupPanel();
         oa.odf.readGroupWordListData();
         oa.addTable();
         oa.addTree();
         oa.op.calculateKoef();
         oa.repaint();
     }catch(Exception ex){
             ex.printStackTrace();
             JOptionPane.showMessageDialog(null, ex.toString(), "File reading problem", JOptionPane.ERROR_MESSAGE);
     }
  }
  public void mousePressed(MouseEvent e){
     selectedWord=oa.op.getWordNr(e.getX(), e.getY());
     mx=my=-1;
     if(selectedWord>-1){
      if((e.getModifiers()&MouseEvent.CTRL_MASK)>0){
        int[] selected=oa.odf.gwordlist.getSelectedIndices();
        boolean found=false;
        for(int i=0; i<selected.length; i++){
            if(selected[i]==selectedWord){
               found=true;
            }
        }
        if(!found){
           int[] newselected=new int[selected.length+1];
           for(int i=0; i<selected.length; i++){
               newselected[i]=selected[i];               
           }
           newselected[selected.length]=selectedWord;
           oa.odf.gwordlist.setSelectedIndices(newselected);
        }
      } else {
        if((e.getModifiers() & MouseEvent.SHIFT_MASK)>0){
          try{
           AppletContext ac=oa.getAppletContext();
           System.out.println(ac);
           ac.showDocument(new java.net.URL("http://www.neti.ee"), "_blank");
          }catch(Exception ex){
             ex.printStackTrace();
          }
        }

         oa.odf.gwordlist.setSelectedIndex(selectedWord);
      }
        oa.table.setRowSelectionInterval(selectedWord, selectedWord);
     } else { // not selectedWord
        mx=e.getX();
        my=e.getY();
     }
  }
  public void mouseReleased(MouseEvent e){
     int mux=e.getX();
     int muy=e.getY();
     if(mx!=-1){
       int[] inarea=oa.op.getWordNumbers(mx, my, mux, muy);
       if((e.getModifiers()&MouseEvent.CTRL_MASK)>0){
          int[] selected=oa.odf.gwordlist.getSelectedIndices();
          int[] newselected=new int[selected.length+inarea.length];
          for(int i=0; i<selected.length; i++){
             newselected[i]=selected[i];             
          }
          for(int i=0; i<inarea.length; i++){
             newselected[selected.length+i]=inarea[i];
          }
          oa.odf.gwordlist.setSelectedIndices(newselected);
       } else {
          oa.odf.gwordlist.setSelectedIndices(inarea);
       }
//       oa.odf.updateGCommentArea();
       oa.odf.updateGCommentList();
     }
     selectedWord=-1;
  }
  public void mouseEntered(MouseEvent e){}
  public void mouseExited(MouseEvent e){}
  public void mouseClicked(MouseEvent e){}
  public void mouseMoved(MouseEvent e){
     int mSelectedWord=oa.op.getWordNr(e.getX(), e.getY());
     if(mSelectedWord>-1){
        oa.op.setToolTipText(oa.od.names[mSelectedWord]);
     } else {
        oa.op.setToolTipText("");
     }
  }
  public void mouseDragged(MouseEvent e){
     if(selectedWord>=0){
        oa.od.coordinates[selectedWord][0]=oa.op.wx(e.getX());
        oa.od.coordinates[selectedWord][1]=oa.op.wy(e.getY());
        oa.repaint();
     }
  }
}