import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import java.util.*;
/**
*  Drawing words to 2D plane. Selecting words.
*/
public class OntoPanel extends JPanel{
    OntoData od;
    OntoApp oa;
    double wcx, wcy, pcx, pcy, koef=1;
    double freeBorder=30;
    boolean zoomToBoundsWhileCalculating=true;
    public void paintComponent(Graphics g0){
     try{
       Graphics2D g=(Graphics2D)g0;
       g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
       pcx=getWidth()/2;
       pcy=getHeight()/2;
       if(zoomToBoundsWhileCalculating){
        if(oa.ol.continousCalculating){
         calculateKoef();
        }
       }
       paintWords(g);
     }catch(Exception e){
        e.printStackTrace();
     }  
    }
    
    void paintWords(Graphics2D g){
       FontMetrics fm=g.getFontMetrics();
//       System.out.println(od.data.length+" "+od.coordinates.length+" "+od.names.length);
       if(oa.odf.bzdrawtype.getSelectedIndex()==0){
        for(int j=0; j<od.names.length; j++){
          int sw=fm.stringWidth(od.names[j]);
          g.drawString(od.names[j], px(od.coordinates[j][0])-sw/2, py(od.coordinates[j][1]));
         }    
       }
       if(oa.odf.bzdrawtype.getSelectedIndex()==1){
         for(int j=0; j<od.names.length; j++){
            g.setColor(Color.blue);
            g.fillRect(px(od.coordinates[j][0])-25, py(od.coordinates[j][1])-10, 50, 15);
            g.setColor(Color.black);
            String s=od.names[j];
            if(s.length()>5){s=s.substring(0, 5);}
            g.drawString(s, px(od.coordinates[j][0])-25, py(od.coordinates[j][1]));
         }
       }

    }
    
    void calculateKoef(){
      if(od.coordinates.length==0){return;}
      if(od.coordinates.length==1){
        wcx=od.coordinates[0][0];
        wcy=od.coordinates[0][1];
        koef=1;
        return;
      }
      double[] koefm=new double[od.coordinates[0].length];
      double tkoefx=0, tkoefy=0;
      for(int i=0; i<od.coordinates[0].length; i++){
         double min=od.coordinates[0][i];
         double max=min;
         for(int j=0; j<od.coordinates.length; j++){
            if(od.coordinates[j][i]<min){min=od.coordinates[j][i];}
            if(od.coordinates[j][i]>max){max=od.coordinates[j][i];
            }
         }
//         min=Math.abs(min);
         if(i==0){
            wcx=(max+min)/2;
            tkoefx=(getWidth()/2-freeBorder)/(max-wcx);
         }
         if(i==1){
            wcy=(max+min)/2;
            tkoefy=(getHeight()/2-freeBorder)/(max-wcy);
         }
         System.out.println(wcx+" ja " +wcy);
      }
      koef=Math.min(tkoefx, tkoefy);
    }
         
         
    
    int px(double wx){
       return (int)(pcx+(wx-wcx)*koef);
    }
    int py(double wy){
       return (int)(pcy-(wy-wcy)*koef);
    }
    double wx(int px){
       return wcx+(px-pcx)/koef;
    }
    double wy(int py){
       return wcy+(pcy-py)/koef;
    }
    int getWordNr(int px, int py){
       int r=15;
       for(int j=0; j<od.coordinates.length; j++){
         if(Math.abs(px(od.coordinates[j][0])-px)<2*r && Math.abs(py(od.coordinates[j][1])-py)<r){
           return j;
         }
       }
       return -1;
    }
    
    int[] getWordNumbers(int px1, int py1, int px2, int py2){
       int x0=Math.min(px1, px2);
       int y0=Math.min(py1, py2);
       int x1=Math.max(px1, px2);
       int y1=Math.max(py1, py2);
       Vector numbers=new Vector();
       for(int j=0; j<od.coordinates.length; j++){
          if(
            px(od.coordinates[j][0])>=x0 && px(od.coordinates[j][0])<=x1 &&
            py(od.coordinates[j][1])>=y0 && py(od.coordinates[j][1])<=y1 
            ){
              numbers.add(new Integer(j));
          }
       }
       int[] answer=new int[numbers.size()];
       for(int i=0; i<answer.length; i++){
          answer[i]=((Integer)numbers.get(i)).intValue();
       }
       return answer;
    }
}