import java.util.*;
/**
* Holds temporary one row data. Word name, values, coordinates, locking, comments.
*/
   class OntoRowData{
      String rname;
      double[] rdata;
      double[] rcoordinates;
      boolean rlocked;
      Vector rcomment;
      static final int CALCTYPE_AVERAGE=1;
      static final int CALCTYPE_SUM=2;
      public String toString(){
        StringBuffer sb=new StringBuffer();
        sb.append(rname+"; ");
        for(int i=0; i<rdata.length; i++){
           if(i>0){sb.append(", ");}
           sb.append(rdata[i]);
        }
        sb.append("; "+rcoordinates[0]+", "+rcoordinates[1]+"; "+rcomment.toString());
        return sb.toString();        
      }
      public OntoRowData(String urname, double[] urdata, double[] urcoordinates, boolean urlocked, Vector urcomment){
         rname=urname;
         rdata=new double[urdata.length];
         for(int i=0; i<urdata.length; i++){
            rdata[i]=urdata[i];
         }
         rcoordinates=new double[urcoordinates.length];
         for(int i=0; i<urcoordinates.length; i++){
            rcoordinates[i]=urcoordinates[i];
         }         
         rlocked=urlocked;
         rcomment=new Vector(urcomment);
      }
      /**
      * Copy from old instance
      */
      public OntoRowData(OntoRowData old){
         this(old.rname, old.rdata, old.rcoordinates, old.rlocked, old.rcomment);
      }
      /**
      * Empty instance with declared space.
      */
      public OntoRowData(int colcount, int dimcount){
         rname="yy";
         rdata=new double[colcount];
         rcoordinates=new double[dimcount];
         rlocked=false;
         rcomment=new Vector();
      }
      public OntoRowData(String uname, OntoRowData[] old, int calctype){
         if(old==null || old.length==0){
           throw new RuntimeException("No old data");
         }
         for(int i=0; i<old.length-1; i++){
            if(old[i].rdata.length!=old[i+1].rdata.length){
               throw new RuntimeException("Invalid data length");
            }
            if(old[i].rcoordinates.length!=old[i+1].rcoordinates.length){
               throw new RuntimeException("Invalid coordinates length");
            }
         }
         rname=uname;
         rdata=new double[old[0].rdata.length];
         for(int i=0; i<rdata.length; i++){
            for(int j=0; j<old.length; j++){
               rdata[i]+=old[j].rdata[i];            
            }
            if(calctype==CALCTYPE_AVERAGE){
               rdata[i]/=old.length;
            }
         }                  
         rcoordinates=new double[old[0].rcoordinates.length];
         for(int i=0; i<rcoordinates.length; i++){
            for(int j=0; j<old.length; j++){
               rcoordinates[i]+=old[j].rcoordinates[i];            
            }
            if(calctype==CALCTYPE_AVERAGE){
               rcoordinates[i]/=old.length;
            }
         }                 
         rlocked=false;
         rcomment=new Vector(); 
      }
   }
