import javax.swing.*;
import javax.swing.event.*;
import java.awt.*;
/**
* Sliders panel displaying perspective coeficients.
*/
public class OntoSliders extends JPanel implements ChangeListener{
   OntoApp oa;
   JSlider[] sliders;
   JSlider masterSlider;
//   JTextField[] stfs;
   public OntoSliders(OntoApp oa){
      this.oa=oa;   
   }
   public void initialize(){
      int masterNr=400;
      removeAll();
//      setLayout(new GridLayout(oa.od.parameters.length+((oa.od.parameters.length>masterNr)?1:0),1));
      setLayout(new GridLayout(oa.od.params.length+((oa.od.params.length>masterNr)?1:0),1));
      sliders=new JSlider[oa.od.params.length];
//      stfs=new JTextField[oa.od.params.length];
      if(sliders.length>masterNr){
         masterSlider=new JSlider(0, 100, 0);
         JPanel p=new JPanel(new BorderLayout());
         JPanel p2=new JPanel(new BorderLayout());
         p2.add(masterSlider, BorderLayout.CENTER);
         p2.add(new JLabel("   "), BorderLayout.EAST);
         p.add(p2, BorderLayout.SOUTH);
         p.add(new JLabel("Master slider"), BorderLayout.NORTH);
         masterSlider.addChangeListener(this);  
         add(p);       
      }
      for(int i=0; i<oa.od.params.length; i++){
         sliders[i]=new JSlider(0, 100, (int)(100*oa.od.params[i].coef));
//         sliders[i]=new JSlider(0, 100, (int)(100*oa.od.perspective[i]));
//         stfs[i]=new JTextField(oa.od.perspective[i]+"", 4);
//         stfs[i]=new JTextField(oa.od.params[i].coef+"", 4);
//         JPanel p=new JPanel(new GridLayout(1, 3));
         JPanel p=new JPanel(new BorderLayout());
//         JPanel p2=new JPanel(new BorderLayout());
         JLabel slbl=new JLabel(oa.od.params[i].name);
         slbl.setToolTipText(oa.od.params[i].name);
         p.add(slbl);
         p.add(sliders[i], BorderLayout.EAST);
         sliders[i].setToolTipText(oa.od.params[i].name);
         sliders[i].setPreferredSize(new Dimension(70, 20));
//         p.add(new JLabel("   "));
         //p.add(p2, BorderLayout.SOUTH);
         //p.add(stfs[i], BorderLayout.EAST);
         add(p);
//         sliders[i].setPaintLabels(true);
//         sliders[i].setPaintTicks(true);
//         sliders[i].setPaintTrack(true);
         sliders[i].addChangeListener(this);
      }
      validate();
   }

   public Dimension getPreferredSize(){
      return new Dimension(270, (30*sliders.length+20 > oa.getHeight())?30*sliders.length+20:oa.getHeight()-50);
   }

   boolean bigMoving=false;
   public void stateChanged(ChangeEvent e){
    if(e.getSource()==masterSlider){
         bigMoving=true;
       for(int i=0; i<sliders.length; i++){
          sliders[i].setValue(masterSlider.getValue());
       }  
         bigMoving=false;
    }
    for(int i=0; i<sliders.length; i++){
        oa.od.params[i].coef=sliders[i].getValue()/100.0;
    }
     if(oa.odf.brautomcalc.isSelected() && !bigMoving){
       oa.ol.iterateN(Integer.parseInt(oa.btf1.getText()));
     }
//    oa.addTree();
   }
}