import javax.swing.*;
import javax.swing.table.*;
import java.text.*;
import java.awt.event.*;
/**
* Wrapper tool between graphical table and OntoData variables. Used
* both in reading and writing.
*/
class OntoTableModel extends AbstractTableModel implements MouseListener, ActionListener{
   OntoApp oa;
   int dimensions=2;
   JPopupMenu popup=new JPopupMenu();
   JMenuItem jmCopyRow=new JMenuItem("Copy row");
   JMenuItem jmDeleteRow=new JMenuItem("Delete row");
   JMenuItem jmInsertRow=new JMenuItem("Insert row");
   JMenuItem jmCutRow=new JMenuItem("Cut row");
   JMenuItem jmPasteRow=new JMenuItem("Paste row");
   public OntoTableModel(OntoApp oa){
      this.oa=oa;
      popup.add(jmInsertRow);
      popup.add(jmDeleteRow);
      popup.add(jmCopyRow);
      popup.add(jmCutRow);
      popup.add(jmPasteRow);
      jmInsertRow.addActionListener(this);
      jmDeleteRow.addActionListener(this);
      jmCopyRow.addActionListener(this);
      jmCutRow.addActionListener(this);
      jmPasteRow.addActionListener(this);
   }
   public int getColumnCount(){
      if(oa.od.data.length==0){return 0;}
      return oa.od.data[0].length+4;
   }
   public int getRowCount(){
      return oa.od.data.length;
   }
   public String getColumnName(int col){
      if(col==0){return "";}
/*
      if(col<=oa.od.parameters.length){return oa.od.parameters[col-1];}
      if(col<=oa.od.parameters.length+dimensions){
        return new String[]{"X", "Y"}[col-1-oa.od.parameters.length];
      }
      if(col==oa.od.parameters.length+dimensions+1){
         return "locked";
      }
*/
      if(col<=oa.od.params.length){return oa.od.params[col-1].name;}
      if(col<=oa.od.params.length+dimensions){
        return new String[]{"X", "Y"}[col-1-oa.od.params.length];
      }
      if(col==oa.od.params.length+dimensions+1){
         return "locked";
      }
      return "??";
   }
   public Object getValueAt(int row, int col){
  //   if(row==0){return getColumnName(col);}
  //   row=row-1;
     if(col==0){return oa.od.names[row];}
     NumberFormat nf=NumberFormat.getNumberInstance();
     nf.setMaximumFractionDigits(3);
     if(col<=oa.od.data[0].length){
          return nf.format(oa.od.data[row][col-1]);
      }
      if(col<=oa.od.params.length+dimensions){
            return nf.format(oa.od.coordinates[row][col-oa.od.data[0].length-1]);
      }
      if(col==oa.od.params.length+dimensions+1){
          return new Boolean(oa.od.locked[row]);
      }
      return "???";
//      return new Integer(200);
   }

   public boolean isCellEditable(int row, int column){
      return true;
   }
   public void setValueAt(Object value, int row, int column){
      if(column>0 && column<=oa.od.data[0].length){
         oa.od.data[row][column-1]=Double.parseDouble(value.toString().replace(',', '.'));
      }
      if(column==0){
        oa.od.names[row]=(String)value;
      }
      if(column>oa.od.data[0].length && column<=oa.od.data[0].length+2){
        oa.od.coordinates[row][column-oa.od.data[0].length-1]=Double.parseDouble(value.toString().replace(',', '.'));
      }
      if(column==oa.od.params.length+dimensions+1){
         if(value.toString().equals("true")){
            oa.od.locked[row]=true;
         }  else {
            oa.od.locked[row]=false;
         }
      }
      oa.repaint();
   }
   
   public Class getColumnClass(int c){
     return getValueAt(0, c).getClass();
   }
   
   public void mousePressed(MouseEvent e){
        if((e.getModifiers()&MouseEvent.ALT_MASK)>0 ||
           (e.getModifiers()&MouseEvent.BUTTON3_MASK)>0){
             int trow=oa.table.getSelectedRow();
             if(trow==-1){
                jmCutRow.setEnabled(false);
                jmDeleteRow.setEnabled(false);
                jmCopyRow.setEnabled(false);
             } else {
                jmCutRow.setEnabled(true);
                jmDeleteRow.setEnabled(true);                
                jmCopyRow.setEnabled(true);                
             }
             if(oa.odf.rowclipboard==null){
                jmPasteRow.setEnabled(false);
             }  else {
                jmPasteRow.setEnabled(true);
             }
             popup.show(oa.table, e.getX(), e.getY());
        }
   }
   public void mouseReleased(MouseEvent e){}
   public void mouseClicked(MouseEvent e){}
   public void mouseEntered(MouseEvent e){}
   public void mouseExited(MouseEvent e){}
   public void actionPerformed(ActionEvent e){
      int trow=oa.table.getSelectedRow();
      boolean rowchanged=false;
/*
      if(e.getSource()==jmInsertRow){
        oa.od.insertRow();
        //oa.addTable();
      }
*/
      if(e.getSource()==jmCutRow){
         if(trow>-1 && trow<oa.od.data.length){
            oa.odf.rowclipboard=oa.od.removeRow(trow);
            rowchanged=true;
         }
      }
      if(e.getSource()==jmCopyRow){
         if(trow>-1 && trow<oa.od.data.length){
            oa.odf.rowclipboard=oa.od.copyRow(trow);
         }
      
      }
      if(e.getSource()==jmPasteRow){
         if(trow==-1){trow=oa.od.data.length;}         
         if(oa.odf.rowclipboard!=null){
           oa.od.insertRow(trow, oa.odf.rowclipboard);
           rowchanged=true;
         }
      }
      if(e.getSource()==jmInsertRow){
         if(trow==-1){trow=oa.od.data.length;}
         oa.od.insertRow(trow);
         rowchanged=true;
      }
      if(e.getSource()==jmDeleteRow){
         if(trow>-1 && trow<oa.od.data.length){
            oa.od.removeRow(trow);
            rowchanged=true;
         }
      }

      if(rowchanged){
         oa.addTable();
         oa.odf.readGroupWordListData();
      }
      
   }
}