import javax.swing.tree.*;
import javax.swing.*;
import java.awt.*;
import java.util.*;
class OntoTreeEditorComponent extends AbstractCellEditor implements TreeCellEditor, TreeCellRenderer{
   JSlider slider=new JSlider();
   //Dictionary dict=new Hashtable();
   JTextField label=new JTextField("test");
   JPanel p=new JPanel(new GridLayout(1, 2));
   OntoApp oa;
   public OntoTreeEditorComponent(OntoApp uoa){
      oa=uoa;
      p.add(label);
      p.add(slider);
     // dict.put(new Integer(1), label);
      //slider.setLabelTable(dict);
      p.setPreferredSize(new Dimension(100, 20));
      slider.addChangeListener(oa.otm);
      label.addActionListener(oa.otm);
      label.addMouseListener(oa.otm);
      slider.addMouseListener(oa.otm);
   }
   public Component getTreeCellEditorComponent(JTree tree, Object value, 
     boolean isSelected, boolean expanded, boolean leaf, int row){
       OntoParam onp=(OntoParam)value;
       oa.otm.editableop=onp;
       slider.setValue((int)(onp.coef*100));
       label.setText(onp.name);
       label.setToolTipText(onp.name);
       slider.setToolTipText(onp.getActualCoef()+"");
       return p;
   }
   
   public Component getTreeCellRendererComponent(JTree tree, Object value, 
     boolean isSelected, boolean expanded, boolean leaf, int row, boolean hasFocus){
      return getTreeCellEditorComponent(tree, value, isSelected, expanded, leaf, row);
   }
   
   public Object getCellEditorValue(){
     //System.out.println("Cell editor value "+slider.getValue());
     return new Double(slider.getValue());
   }
   public boolean isCellEditable(EventObject anEvent){
      return true;
   }
}