import javax.swing.*;
import javax.swing.tree.*;
import javax.swing.event.*;
import java.awt.event.*;

public class OntoTreeModel implements TreeModel, TreeSelectionListener, 
    ChangeListener, ActionListener, MouseListener{
   OntoApp oa;
   OntoParam editableop=null;
   JPopupMenu popup=new JPopupMenu("Tree");
   JMenuItem jmAddGroup=new JMenuItem("Add new group");
   JMenuItem jmRemoveGroup=new JMenuItem("Remove group");
   JMenuItem jmPasteItem=new JMenuItem("Move here");
   JPopupMenu itempopup=new JPopupMenu("Item");
   JMenuItem jmCopyItem=new JMenuItem("Copy");
   JMenuItem jmDuplicateItem=new JMenuItem("Duplicate");
   OntoParam[] clipboardItems=null;

   public OntoTreeModel(OntoApp oa){
      this.oa=oa;
      popup.add(jmAddGroup);	
      popup.add(jmRemoveGroup);
      jmPasteItem.addActionListener(this);
      jmAddGroup.addActionListener(this);
      jmRemoveGroup.addActionListener(this);
      popup.add(jmCopyItem);
      jmCopyItem.addActionListener(this);
      jmDuplicateItem.addActionListener(this);
   }
   public void addTreeModelListener(TreeModelListener l){
//     System.out.println("Add tree model listener "+l);
   }
   public Object getChild(Object parent, int index){
      if(parent instanceof OntoParamGroup){
         OntoParamGroup opg=(OntoParamGroup)parent;
         if(index < opg.childgroups.size()){
            return opg.childgroups.get(index);
         }
         if(index < opg.childgroups.size()+opg.parameters.size()){
            return opg.parameters.get(index-opg.childgroups.size());
         }
      }
      return null;
   }
   public int getChildCount(Object parent){
      if(parent instanceof OntoParamGroup){
         OntoParamGroup opg=(OntoParamGroup)parent;
         return opg.childgroups.size()+opg.parameters.size();
      }
      return 0;
   }
   public int getIndexOfChild(Object parent, Object child){
      if(isLeaf(parent)){return -1;}
      OntoParamGroup opg=(OntoParamGroup)parent;
      if(child instanceof OntoParamGroup){
         return opg.childgroups.indexOf((OntoParamGroup)child);
      }
      if(child instanceof OntoParam){
         return opg.parameters.indexOf((OntoParam)child);
      }
      return -1;
   }
   public Object getRoot(){
      return oa.od.rootgroup;
   }
   public boolean isLeaf(Object node){
      return !(node instanceof OntoParamGroup);
   }
   public void removeTreeModelListener(TreeModelListener l){
      System.out.println("Remove tree model listener "+l);
   }
   public void valueForPathChanged(TreePath path, Object newValue){
     // System.out.println(path+"; "+newValue);
   }
   public void valueChanged(TreeSelectionEvent e){
      //oa.reloadLayout();
      
      oa.os.initialize();
      oa.addTable();
     // System.out.println("value Changed ");
     // editableop=(OntoParam)oa.tree.getLastSelectedPathComponent();
     // System.out.println(editableop.name+" "+editableop.coef);
   }
   public void stateChanged(ChangeEvent e){
    if(editableop==null)return;
    //System.out.println("state "+editableop+" "+editableop.coef);
     editableop.coef=oa.otec.slider.getValue()/100.0;
     if(oa.odf.brautomcalc.isSelected()){
       oa.ol.iterateN(Integer.parseInt(oa.btf1.getText()));
     }
     // System.out.println("state changed "+oa.otec.slider.getValue());
//     OntoParam opm=(OntoParam)oa.tree.getLastSelectedPathComponent();
//     opm.coef=oa.otec.slider.getValue()/100.0;
     //System.out.println("STATE "+editableop.name+" "+editableop.coef);
//     OntoParam abi=opm.parent.getParameter(2);
//     System.out.println(abi.name+" "+abi.coef+" "+(opm==abi));
//      System.out.println(oa.tree.getLastSelectedPathComponent());
      
   }
   public void actionPerformed(ActionEvent e){
      if(e.getSource()==oa.otec.label){
         OntoParam opm=(OntoParam)oa.tree.getLastSelectedPathComponent();
         opm.name=oa.otec.label.getText();  
         oa.tree.cancelEditing();       
         oa.tree.setEditable(false);
      }
      if(e.getSource()==jmAddGroup){
         OntoParamGroup opg=(OntoParamGroup)oa.tree.getLastSelectedPathComponent();
         TreePath editingPath=oa.tree.getEditingPath();
         if(editingPath==null){
            editingPath=oa.tree.getSelectionPath();
         }
         OntoParamGroup newgroup=new OntoParamGroup("new group", 1.0, opg);
         opg.addChildGroup(newgroup);
         //oa.tree.revalidate();
         oa.addTree();
         oa.tree.setSelectionPath(editingPath.pathByAddingChild(newgroup));
      }
      if(e.getSource()==jmRemoveGroup){
         OntoParamGroup opg=(OntoParamGroup)oa.tree.getLastSelectedPathComponent();
         TreePath editingPath=oa.tree.getEditingPath();
         if(editingPath==null){
            editingPath=oa.tree.getSelectionPath();
         }
         if(opg.isEmpty()){
            opg.parent.childgroups.remove(opg);
         }         
         oa.addTree();
         oa.tree.setSelectionPath(editingPath.getParentPath());
      }
      if(e.getSource()==jmCopyItem){
         //OntoParam opm=(OntoParam)oa.tree.getLastSelectedPathComponent();
         TreePath[] paths=oa.tree.getSelectionPaths();
         clipboardItems=new OntoParam[paths.length];
         for(int k=0; k<paths.length; k++){
            clipboardItems[k]=(OntoParam)paths[k].getLastPathComponent();
         }
         if(popup.getComponentIndex(jmPasteItem)==-1){
           popup.add(jmPasteItem);
         }
      }
      if(e.getSource()==jmPasteItem){
         OntoParamGroup opg=(OntoParamGroup)oa.tree.getLastSelectedPathComponent();
         TreePath editingPath=oa.tree.getEditingPath();
         if(editingPath==null){
            editingPath=oa.tree.getSelectionPath();
         }
         if(clipboardItems!=null){
            for(int k=0; k<clipboardItems.length; k++){
              if(clipboardItems[k] instanceof OntoParamGroup){
                 opg.addChildGroup((OntoParamGroup)clipboardItems[k]);
              } else {
                 opg.addParameter(clipboardItems[k]);               
              }
            }
         } else {
            return;
         }
         if(popup.getComponentIndex(jmPasteItem)>-1){
           popup.remove(popup.getComponentIndex(jmPasteItem));
         }
         oa.addTree();
         oa.tree.setSelectionPath(editingPath.pathByAddingChild(clipboardItems[0]));         
         clipboardItems=null;
      }
      if(e.getSource()==jmDuplicateItem){
         int nr=-1;
         OntoParam opm=(OntoParam)oa.tree.getLastSelectedPathComponent();
         TreePath editingPath=oa.tree.getEditingPath();
         if(editingPath==null){
            editingPath=oa.tree.getSelectionPath();
         }
         for(int k=0; k<oa.od.params.length; k++){
            if(oa.od.params[k]==opm){
               nr=k;
            }
         }
         if(nr!=-1){
            oa.od.duplicateColumn(nr);
            oa.addTree();
            oa.addTable();
            oa.tree.setSelectionPath(editingPath);
         }
      }
   }
     public void mousePressed(MouseEvent e){}
   public void mouseReleased(MouseEvent e){
    // System.out.println(oa.tree.getPathForLocation(e.getX(), e.getY()));
         TreePath current=oa.tree.getPathForLocation(e.getX(), e.getY());
         if(current!=null && !oa.tree.isPathSelected(current) && !oa.tree.isEditable()){         
           TreePath[] paths=oa.tree.getSelectionPaths();
           if(paths==null){return;}
           OntoParam[] selectedItems=new OntoParam[paths.length];
           for(int k=0; k<paths.length; k++){
              selectedItems[k]=(OntoParam)paths[k].getLastPathComponent();
           }
           OntoParam currentParam=(OntoParam)current.getLastPathComponent();  
           if(currentParam instanceof OntoParamGroup){
               OntoParamGroup currentGroup=(OntoParamGroup)currentParam;
               for(int i=0; i<selectedItems.length; i++){
                  if(selectedItems[i] instanceof OntoParamGroup){
                     currentGroup.addChildGroup((OntoParamGroup)selectedItems[i]);
                  } else {
                     currentGroup.addParameter(selectedItems[i]);
                  }
               }             
           } else {
             OntoParamGroup currentGroup=currentParam.parent;
             int index=currentGroup.parameters.indexOf(currentParam);
             for(int i=selectedItems.length-1; i>=0; i--){
                currentGroup.addParameter(selectedItems[i], index+1);
             }
           }        
           oa.addTree();
           oa.tree.setSelectionPath(current);
         }
   }
   public void mouseClicked(MouseEvent e){
      //if(e.isPopupTrigger()){
       if((e.getModifiers()&MouseEvent.ALT_MASK)>0 ||
           (e.getModifiers()&MouseEvent.BUTTON3_MASK)>0){
         if(oa.tree.getSelectionPaths()==null){
           System.out.println("Not selected");
           return;         
         }
         if(popup.getComponentIndex(jmDuplicateItem)>-1){
           popup.remove(popup.getComponentIndex(jmDuplicateItem));
         }
         if(oa.tree.getSelectionPaths().length==1 && 
           oa.tree.getLastSelectedPathComponent() instanceof OntoParamGroup){
            OntoParamGroup opg=(OntoParamGroup)oa.tree.getLastSelectedPathComponent();
            jmAddGroup.setEnabled(true);
            jmRemoveGroup.setEnabled(opg.isEmpty());
            jmCopyItem.setEnabled(opg.parent!=null);
            jmPasteItem.setEnabled(clipboardItems!=null);
            popup.show((JComponent)e.getSource(), e.getX(), e.getY());
         } else {
           jmPasteItem.setEnabled(false);
           if(oa.tree.getSelectionPaths().length==1){
             popup.add(jmDuplicateItem);
           }
           if(oa.tree.getSelectionPaths().length>=1){
             jmAddGroup.setEnabled(false);
             jmRemoveGroup.setEnabled(false);
             jmCopyItem.setEnabled(true);
             popup.show((JComponent)e.getSource(), e.getX(), e.getY());        
           } else {
             System.out.println("Not selected");
           }
         }
       } else {
         if(e.getClickCount()==2 && oa.tree.getSelectionPaths()!=null &&
           oa.tree.getSelectionPaths().length==1 && oa.tree.getPathForLocation(e.getX(), e.getY())!=null){
              oa.tree.setEditable(true);
         } else {
              oa.tree.setEditable(false);
         }
         if(e.getSource()==oa.tree && e.getClickCount()==1){
           oa.tree.setEditable(false);
         }
       }
      //}
   }
   public void mouseEntered(MouseEvent e){}
   public void mouseExited(MouseEvent e){}
}